/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.arrays;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NotImplementedError;
import org.kingdoms.libs.kotlin.collections.AbstractList;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.jvm.internal.markers.KMutableIterator;
import org.kingdoms.libs.kotlin.jvm.internal.markers.KMutableList;
import org.kingdoms.utils.internal.nonnull.Nullability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u000b\n\u0002\u0010)\n\u0000\n\u0002\u0010+\n\u0002\b\f\u0018\u0000*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00022\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u00032\u00060\u0004j\u0002`\u00052\u00020\u00062\u00020\u0007:\u00011B\u000f\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0018H\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\t2\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0018H\u0016J\u001f\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001cJ\u0017\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u0014H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0006\u0010 \u001a\u00020\u0016J\u0016\u0010!\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\"J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0096\u0002J\u0010\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000&H\u0016J\u0018\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000&2\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0017\u0010'\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\"J \u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u00032\u0006\u0010)\u001a\u00020\t2\u0006\u0010*\u001a\u00020\tH\u0016J\"\u0010+\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0019\u001a\u00020\t2\b\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010,J\u0018\u0010-\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0018H\u0016J\u0018\u0010.\u001a\u00020\u00162\u000e\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0018H\u0016J\u0017\u0010/\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0018\u00100\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00018\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u001dR\u0018\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u000b\u00a8\u00062"}, d2={"Lorg/kingdoms/utils/internal/arrays/FixedArrayList;", "E", "Lorg/kingdoms/libs/kotlin/collections/AbstractList;", "", "Ljava/util/RandomAccess;", "Lorg/kingdoms/libs/kotlin/collections/RandomAccess;", "", "Ljava/io/Serializable;", "size", "", "<init>", "(I)V", "array", "", "", "[Ljava/lang/Object;", "getSize", "()I", "setSize", "clear", "", "addAll", "", "elements", "", "index", "add", "element", "(ILjava/lang/Object;)V", "(Ljava/lang/Object;)Z", "checkFull", "checkIndex", "isFull", "get", "(I)Ljava/lang/Object;", "iterator", "", "listIterator", "", "removeAt", "subList", "fromIndex", "toIndex", "set", "(ILjava/lang/Object;)Ljava/lang/Object;", "retainAll", "removeAll", "remove", "contains", "Iterator", "shared"})
@SourceDebugExtension(value={"SMAP\nFixedArrayList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedArrayList.kt\norg/kingdoms/utils/internal/arrays/FixedArrayList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1863#2,2:132\n*S KotlinDebug\n*F\n+ 1 FixedArrayList.kt\norg/kingdoms/utils/internal/arrays/FixedArrayList\n*L\n18#1:132,2\n*E\n"})
public final class FixedArrayList<E>
extends AbstractList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable,
KMutableList {
    @NotNull
    private final Object[] array;
    private int size;

    public FixedArrayList(int size) {
        this.array = new Object[size];
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public void clear() {
        ArraysKt.fill$default((Object[])this.array, null, (int)0, (int)0, (int)6, null);
        this.setSize(0);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        java.util.Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object x = element$iv = iterator.next();
            boolean bl = false;
            this.add(x);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, @Nullable E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(@Nullable E element) {
        this.checkFull();
        int n = this.size();
        this.setSize(n + 1);
        this.array[n] = element;
        return true;
    }

    private final void checkFull() {
        if (this.isFull()) {
            throw new IllegalStateException("List already full");
        }
    }

    private final void checkIndex(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException(index + " >= " + this.size());
        }
        if (index < 0) {
            throw new IllegalArgumentException("Index is negative: " + index);
        }
    }

    public final boolean isFull() {
        return this.size() == this.array.length;
    }

    @Override
    public E get(int index) {
        this.checkIndex(index);
        return (E)this.array[index];
    }

    @Override
    @NotNull
    public java.util.Iterator<E> iterator() {
        return new Iterator();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public E removeAt(int index) {
        this.checkIndex(index);
        Object prev = this.array[index];
        this.array[index] = null;
        int n = this.size();
        this.setSize(n + -1);
        return (E)prev;
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public E set(int index, @Nullable E element) {
        Nullability.assertNonNull(this, element);
        this.checkIndex(index);
        Object prev = this.array[index];
        this.array[index] = element;
        return (E)prev;
    }

    @Override
    public boolean retainAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Nullability.assertNonNullElements(elements);
        boolean modified = false;
        Object[] objectArray = this.array;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            Object element = objectArray[i];
            if (CollectionsKt.contains((Iterable)elements, (Object)element)) continue;
            this.array[index] = null;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Nullability.assertNonNullElements(elements);
        boolean modified = false;
        for (Object object : elements) {
            if (!this.remove(object)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean remove(@Nullable Object element) {
        Nullability.assertNonNull(this, element);
        Object[] objectArray = this.array;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            int index = i;
            Object currEle = objectArray[i];
            if (!Intrinsics.areEqual((Object)currEle, (Object)element)) continue;
            this.array[index] = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return ArraysKt.contains((Object[])this.array, (Object)Nullability.assertNonNull(this, element));
    }

    @NotNull
    public Object clone() {
        return super.clone();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\u000e\u0010\b\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/kingdoms/utils/internal/arrays/FixedArrayList$Iterator;", "", "<init>", "(Lorg/kingdoms/utils/internal/arrays/FixedArrayList;)V", "index", "", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "shared"})
    public final class Iterator
    implements java.util.Iterator<E>,
    KMutableIterator {
        private int index;

        @Override
        public boolean hasNext() {
            return this.index < FixedArrayList.this.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Index: " + this.index);
            }
            int n = this.index;
            this.index = n + 1;
            return FixedArrayList.this.array[n];
        }

        @Override
        public void remove() {
        }
    }
}

