/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal.arrays;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.common.value.qual.IntRange;
import org.kingdoms.libs.checkerframework.dataflow.qual.Pure;

public final class ArrayUtils {
    @Pure
    public static <T> T[] reverse(T[] array) {
        int i = 0;
        for (int j = array.length - 1; j > i; ++i, --j) {
            T tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
        return array;
    }

    public static <T> T[] require(T[] array, Predicate<T> requirement) {
        for (T element : array) {
            if (requirement.test(element)) continue;
            throw new IllegalStateException("Array element did not pass requirement");
        }
        return array;
    }

    public static int sizeOfIterator(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static <T> T getLast(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(list.size() - 1);
    }

    public static String[] mergeObjects(Object ... objects) {
        ArrayList<String> list = new ArrayList<String>(objects.length * 2);
        for (Object object : objects) {
            if (object instanceof Object[]) {
                for (Object o : (Object[])object) {
                    list.add(o.toString());
                }
                continue;
            }
            list.add(object.toString());
        }
        return list.toArray(new String[0]);
    }

    public static <T> T[] merge(T[] array1, T[] array2) {
        Object[] joinedArray = (Object[])Array.newInstance(array1.getClass().getComponentType(), array1.length + array2.length);
        System.arraycopy(array1, 0, joinedArray, 0, array1.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    public static Object[] shift(Object[] array) {
        Object[] result = new Object[array.length - 1];
        System.arraycopy(array, 1, result, 0, result.length);
        return result;
    }

    public static <T> void shuffle(T[] array) {
        Random rnd = new Random();
        for (int i = array.length - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            T a = array[index];
            array[index] = array[i];
            array[i] = a;
        }
    }

    public static <T> ConditionalBuilder<T> when(boolean cond, T item) {
        return new ConditionalBuilder<T>(new ArrayList()).when(cond, item);
    }

    public static <T> T[] malloc(@NonNull T[] initial, @IntRange(from=1L, to=0x7FFFFFFFL) int length) {
        if (length <= initial.length) {
            throw new IllegalArgumentException("Cannot allocate array with the same or smaller size than the initial array " + length + " <= " + initial.length);
        }
        Object[] arr = (Object[])Array.newInstance(initial.getClass().getComponentType(), length);
        System.arraycopy(initial, 0, arr, 0, initial.length);
        return arr;
    }

    public static final class ConditionalBuilder<T> {
        protected final Collection<T> collection;

        private ConditionalBuilder(Collection<T> collection) {
            this.collection = collection;
        }

        public ConditionalBuilder<T> when(boolean cond, T item) {
            if (cond) {
                this.collection.add(item);
            }
            return this;
        }

        public Collection<T> build() {
            return this.collection;
        }

        public T[] toArray(T[] a) {
            return this.collection.toArray(a);
        }
    }
}

