/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin._Assertions;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.ArrayIteratorKt;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00132\u00060\u0001j\u0002`\u0002:\u0004\u0010\u0011\u0012\u0013B\u001b\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000fH\u0016R\u001b\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lorg/kingdoms/utils/internal/MultipleException;", "Ljava/lang/RuntimeException;", "Lorg/kingdoms/libs/kotlin/RuntimeException;", "exceptions", "", "", "<init>", "([Ljava/lang/Throwable;)V", "getExceptions", "()[Ljava/lang/Throwable;", "[Ljava/lang/Throwable;", "printStackTrace", "", "s", "Ljava/io/PrintStream;", "Ljava/io/PrintWriter;", "SimplePrinter", "SimpleStreamPrinter", "SimpleWriterPrinter", "Companion", "shared"})
final class MultipleException
extends RuntimeException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Throwable[] exceptions;
    @NotNull
    private static final String CAUSE_CAPTION = "Caused by: ";
    @NotNull
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";

    public MultipleException(Throwable ... exceptions) {
        Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
        this.exceptions = exceptions;
    }

    @NotNull
    public final Throwable[] getExceptions() {
        return this.exceptions;
    }

    @Override
    public void printStackTrace() {
        PrintStream printStream = System.err;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"err");
        this.printStackTrace(printStream);
    }

    @Override
    public void printStackTrace(@NotNull PrintStream s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Companion.printStackTrace(this, new SimpleStreamPrinter(s));
    }

    @Override
    public void printStackTrace(@NotNull PrintWriter s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Companion.printStackTrace(this, new SimpleWriterPrinter(s));
    }

    @JvmStatic
    public static final void printStackTrace(@NotNull Throwable ex, @NotNull SimplePrinter printer) {
        Companion.printStackTrace(ex, printer);
    }

    @JvmStatic
    private static final void printEnclosedStackTrace(Throwable ex, SimplePrinter s, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu) {
        MultipleException.Companion.printEnclosedStackTrace(ex, s, enclosingTrace, caption, prefix, dejaVu);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007JI\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u0015H\u0003\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/kingdoms/utils/internal/MultipleException$Companion;", "", "<init>", "()V", "CAUSE_CAPTION", "", "SUPPRESSED_CAPTION", "printStackTrace", "", "ex", "", "printer", "Lorg/kingdoms/utils/internal/MultipleException$SimplePrinter;", "printEnclosedStackTrace", "s", "enclosingTrace", "", "Ljava/lang/StackTraceElement;", "caption", "prefix", "dejaVu", "", "(Ljava/lang/Throwable;Lorg/kingdoms/utils/internal/MultipleException$SimplePrinter;[Ljava/lang/StackTraceElement;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "shared"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void printStackTrace(@NotNull Throwable ex, @NotNull SimplePrinter printer) {
            Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
            Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
            Set<Throwable> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
            dejaVu.add(ex);
            SimplePrinter simplePrinter = printer;
            synchronized (simplePrinter) {
                boolean bl = false;
                printer.println("aaaaaaaaaaaaaaaaaaaaaaaaaaa");
                printer.println(Companion);
                StackTraceElement[] stackTraceElementArray = ex.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                StackTraceElement[] trace = stackTraceElementArray;
                int n = trace.length;
                for (int i = 0; i < n; ++i) {
                    StackTraceElement traceElement = trace[i];
                    printer.println("\tat " + traceElement);
                }
                Iterator iterator = ArrayIteratorKt.iterator((Object[])ex.getSuppressed());
                while (iterator.hasNext()) {
                    Throwable se = (Throwable)iterator.next();
                    Intrinsics.checkNotNull((Object)se);
                    Intrinsics.checkNotNull(dejaVu);
                    Companion.printEnclosedStackTrace(se, printer, trace, MultipleException.SUPPRESSED_CAPTION, "\t", dejaVu);
                }
                Throwable ourCause = ex.getCause();
                if (ourCause != null) {
                    Intrinsics.checkNotNull(dejaVu);
                    Companion.printEnclosedStackTrace(ourCause, printer, trace, MultipleException.CAUSE_CAPTION, "", dejaVu);
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @JvmStatic
        private final void printEnclosedStackTrace(Throwable ex, SimplePrinter s, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu) {
            boolean bl = Thread.holdsLock(s);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (dejaVu.contains(ex)) {
                s.println(prefix + caption + "[CIRCULAR REFERENCE: " + this + ']');
            } else {
                dejaVu.add(ex);
                StackTraceElement[] stackTraceElementArray = ex.getStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
                StackTraceElement[] trace = stackTraceElementArray;
                int m = trace.length - 1;
                for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && Intrinsics.areEqual((Object)trace[m], (Object)enclosingTrace[n]); --m, --n) {
                }
                int framesInCommon = trace.length - 1 - m;
                s.println(prefix + caption + this);
                int i22 = 0;
                int n = m;
                if (i22 <= n) {
                    while (true) {
                        s.println(prefix + "\tat " + trace[i22]);
                        if (i22 == n) break;
                        ++i22;
                    }
                }
                if (framesInCommon != 0) {
                    s.println(prefix + "\t... " + framesInCommon + " more");
                }
                Iterator i22 = ArrayIteratorKt.iterator((Object[])ex.getSuppressed());
                while (i22.hasNext()) {
                    Throwable se = (Throwable)i22.next();
                    this.printEnclosedStackTrace(ex, s, trace, MultipleException.SUPPRESSED_CAPTION, prefix + '\t', dejaVu);
                }
                Throwable ourCause = ex.getCause();
                if (ourCause != null) {
                    this.printEnclosedStackTrace(ourCause, s, trace, MultipleException.CAUSE_CAPTION, prefix, dejaVu);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H&\u00a8\u0006\u0007"}, d2={"Lorg/kingdoms/utils/internal/MultipleException$SimplePrinter;", "", "<init>", "()V", "println", "", "str", "shared"})
    public static abstract class SimplePrinter {
        public abstract void println(@NotNull Object var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/kingdoms/utils/internal/MultipleException$SimpleStreamPrinter;", "Lorg/kingdoms/utils/internal/MultipleException$SimplePrinter;", "obj", "Ljava/io/PrintStream;", "<init>", "(Ljava/io/PrintStream;)V", "getObj", "()Ljava/io/PrintStream;", "println", "", "str", "", "shared"})
    private static final class SimpleStreamPrinter
    extends SimplePrinter {
        @NotNull
        private final PrintStream obj;

        public SimpleStreamPrinter(@NotNull PrintStream obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            this.obj = obj;
        }

        @NotNull
        public final PrintStream getObj() {
            return this.obj;
        }

        @Override
        public void println(@NotNull Object str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.obj.println(str);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/kingdoms/utils/internal/MultipleException$SimpleWriterPrinter;", "Lorg/kingdoms/utils/internal/MultipleException$SimplePrinter;", "obj", "Ljava/io/PrintWriter;", "<init>", "(Ljava/io/PrintWriter;)V", "getObj", "()Ljava/io/PrintWriter;", "println", "", "str", "", "shared"})
    private static final class SimpleWriterPrinter
    extends SimplePrinter {
        @NotNull
        private final PrintWriter obj;

        public SimpleWriterPrinter(@NotNull PrintWriter obj) {
            Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
            this.obj = obj;
        }

        @NotNull
        public final PrintWriter getObj() {
            return this.obj;
        }

        @Override
        public void println(@NotNull Object str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            this.obj.println(str);
        }
    }
}

