/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.KotlinNothingValueException;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.managers.GeneralizedEventWatcher;
import org.kingdoms.utils.string.Strings;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001b\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0005J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0005H\u0002R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/kingdoms/utils/internal/JavaParser;", "", "methodParent", "Ljava/lang/Class;", "javaCode", "", "<init>", "(Ljava/lang/Class;Ljava/lang/String;)V", "index", "", "methodChainDesc", "Ljava/util/StringJoiner;", "methodChain", "", "Ljava/lang/reflect/Method;", "previousIndex", "error", "", "str", "parse", "Lorg/kingdoms/managers/GeneralizedEventWatcher$MethodChain;", "parseBasicExpression", "", "parseMethod", "methodCall", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nJavaParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaParser.kt\norg/kingdoms/utils/internal/JavaParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1#2:87\n*E\n"})
public final class JavaParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Class<?> methodParent;
    @NotNull
    private final String javaCode;
    private int index;
    @NotNull
    private final StringJoiner methodChainDesc;
    @NotNull
    private final List<Method> methodChain;
    private int previousIndex;

    public JavaParser(@NotNull Class<?> methodParent, @NotNull String javaCode) {
        Intrinsics.checkNotNullParameter(methodParent, (String)"methodParent");
        Intrinsics.checkNotNullParameter((Object)javaCode, (String)"javaCode");
        this.methodParent = methodParent;
        this.javaCode = javaCode;
        this.methodChainDesc = new StringJoiner(" -> ");
        this.methodChain = new ArrayList();
    }

    @NotNull
    public final Void error(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        throw new IllegalArgumentException(str + " at " + this.index + ":\n   " + this.javaCode + "\n   " + Strings.repeat(' ', this.index - 1) + '^');
    }

    @NotNull
    public final GeneralizedEventWatcher.MethodChain parse() {
        while (true) {
            int n;
            int it = n = StringsKt.indexOf$default((CharSequence)this.javaCode, (char)'.', (int)this.previousIndex, (boolean)false, (int)4, null);
            boolean bl = false;
            this.index = it;
            if (n == -1) break;
            String string = this.javaCode.substring(this.previousIndex, this.index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.parseMethod(string);
        }
        String string = this.javaCode.substring(this.previousIndex);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        this.parseMethod(string);
        return new GeneralizedEventWatcher.MethodChain(this.methodChain);
    }

    public final void parseBasicExpression(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
    }

    private final void parseMethod(String methodCall) {
        if (((CharSequence)methodCall).length() == 0) {
            this.error("Expected a method call (dot with no method)");
            throw new KotlinNothingValueException();
        }
        char firstChar = methodCall.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar)) {
            this.error("Invalid method call character");
            throw new KotlinNothingValueException();
        }
        boolean startedParens = false;
        boolean endedMethod = false;
        String string = methodCall.substring(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char idParts : cArray) {
            if (startedParens) {
                if (endedMethod) {
                    this.error("Unexpected character after method call");
                    throw new KotlinNothingValueException();
                }
                if (idParts == ')') {
                    endedMethod = true;
                    continue;
                }
                this.error("Expected method closing ) instead");
                throw new KotlinNothingValueException();
            }
            if (Character.isJavaIdentifierPart(idParts)) continue;
            if (idParts == '(') {
                startedParens = true;
                continue;
            }
            this.error("Invalid method call character '" + idParts + '\'');
            throw new KotlinNothingValueException();
        }
        if (startedParens && !endedMethod) {
            this.error("No method closing ) found");
            throw new KotlinNothingValueException();
        }
        String string2 = methodCall.substring(0, methodCall.length() - 2);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String methodName = string2;
        this.methodChainDesc.add(this.methodParent.getName() + ' ' + methodCall);
        try {
            Method method = this.methodParent.getMethod(methodName, new Class[0]);
            method.setAccessible(true);
            Intrinsics.checkNotNull((Object)method);
            this.methodChain.add(method);
            this.methodParent = method.getReturnType();
        }
        catch (NoSuchMethodException e) {
            Method sigMismatch = GeneralizedEventWatcher.findMethodWithName(this.methodParent, methodName);
            String hint = sigMismatch == null ? "" : " (Did you mean to use '" + sigMismatch + "' instead? If yes, you can't because this method requires parameters to be invoked) ";
            this.error("Unknown method '" + this.methodChainDesc + "' " + hint);
            throw new KotlinNothingValueException();
        }
        this.previousIndex = this.index + 1;
    }

    @JvmStatic
    @NotNull
    public static final GeneralizedEventWatcher.MethodChain parse(@NotNull Class<?> clazz, @NotNull String javaCode) {
        return Companion.parse(clazz, javaCode);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lorg/kingdoms/utils/internal/JavaParser$Companion;", "", "<init>", "()V", "parse", "Lorg/kingdoms/managers/GeneralizedEventWatcher$MethodChain;", "clazz", "Ljava/lang/Class;", "javaCode", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GeneralizedEventWatcher.MethodChain parse(@NotNull Class<?> clazz, @NotNull String javaCode) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)javaCode, (String)"javaCode");
            return new JavaParser(clazz, javaCode).parse();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

