/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

public class ByteArrayOutputStream
extends OutputStream {
    private int size;
    private byte[] buf;
    private static final int SOFT_MAX_ARRAY_LENGTH = 0x7FFFFFF7;

    public ByteArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    private static int newLength(int oldLength, int minGrowth, int prefGrowth) {
        int prefLength = oldLength + Math.max(minGrowth, prefGrowth);
        if (0 < prefLength && prefLength <= 0x7FFFFFF7) {
            return prefLength;
        }
        int minLength = oldLength + minGrowth;
        if (minLength < 0) {
            throw new OutOfMemoryError("Required array length " + oldLength + " + " + minGrowth + " is too large");
        }
        return Math.max(minLength, 0x7FFFFFF7);
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.buf.length;
        int minGrowth = minCapacity - oldCapacity;
        if (minGrowth > 0) {
            this.buf = Arrays.copyOf(this.buf, ByteArrayOutputStream.newLength(oldCapacity, minGrowth, oldCapacity));
        }
    }

    @Override
    public void write(int b) {
        this.ensureCapacity(this.size + 1);
        this.buf[this.size] = (byte)b;
        ++this.size;
    }

    public void writeEnsuredCapacity(int b) {
        this.buf[this.size] = (byte)b;
        ++this.size;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ensureCapacity(this.size + len);
        System.arraycopy(b, off, this.buf, this.size, len);
        this.size += len;
    }

    public void writeEnsuredCapacity(byte[] b, int off, int len) {
        System.arraycopy(b, off, this.buf, this.size, len);
        this.size += len;
    }

    public void writeBytes(byte[] b) {
        this.write(b, 0, b.length);
    }

    public void writeBytesEnsuredCapacity(byte[] b) {
        this.writeEnsuredCapacity(b, 0, b.length);
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        return "ByteArrayOutputStream(" + this.buf.length + '/' + this.size + ')';
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public byte[] getArray() {
        if (this.buf.length == this.size) {
            return this.buf;
        }
        return Arrays.copyOf(this.buf, this.size);
    }

    public boolean equals(ByteArrayOutputStream obj) {
        if (this.size != obj.size) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.size > 1000 && (this.buf[this.size / 3] != obj.buf[this.size / 3] || this.buf[this.size / 2] != obj.buf[this.size / 2] || this.buf[this.size - 10] != obj.buf[this.size - 10])) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.buf[i] == obj.buf[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void close() throws IOException {
    }
}

