/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.hash;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.bukkit.entity.Entity;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.utils.hash.EntityHashSet;

public class EntityWeakHashSet<E extends Entity>
extends EntityHashSet<EntityWeakHashSet<E>, E> {
    private final Set<E> set;

    protected EntityWeakHashSet(Class<E> entityClass, int size, BiConsumer<EntityWeakHashSet<E>, E> leaveHandle, BiConsumer<EntityWeakHashSet<E>, E> deathHandle) {
        super(entityClass, leaveHandle, deathHandle);
        this.set = Collections.newSetFromMap(new WeakHashMap(size));
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public boolean contains(E o) {
        return this.set.contains(o);
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        this.set.forEach(action);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(E entity2) {
        return this.set.add(entity2);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean remove(E o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.set.removeIf(filter);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.set.spliterator();
    }

    @Override
    public Stream<E> stream() {
        return this.set.stream();
    }

    @Override
    public Stream<E> parallelStream() {
        return this.set.parallelStream();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.set + ')';
    }
}

