/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.fs.walker.visitors;

import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.utils.fs.walker.visitors.ConditionalPathVisitor;
import org.kingdoms.utils.fs.walker.visitors.ExactPathFilter;
import org.kingdoms.utils.fs.walker.visitors.PathVisit;
import org.kingdoms.utils.fs.walker.visitors.PathVisitor;
import org.kingdoms.utils.fs.walker.visitors.SkipAll;
import org.kingdoms.utils.fs.walker.visitors.StartsWithPathFilter;
import org.kingdoms.utils.fs.walker.visitors.VisitAll;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J \u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J \u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J&\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u001c\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00000\u001eJ\u0014\u0010\u001f\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u0014\u0010 \u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u0014\u0010!\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u0014\u0010\"\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0015J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0015J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0015J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0015J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010&\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020)H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006*"}, d2={"Lorg/kingdoms/utils/fs/walker/visitors/FunctionalPathVisitor;", "Lorg/kingdoms/utils/fs/walker/visitors/PathVisitor;", "root", "Ljava/nio/file/Path;", "<init>", "(Ljava/nio/file/Path;)V", "getRoot", "()Ljava/nio/file/Path;", "visitors", "", "Lorg/kingdoms/utils/fs/walker/visitors/ConditionalPathVisitor;", "getVisitors", "()Ljava/util/List;", "setVisitors", "(Ljava/util/List;)V", "getPathPredicate", "Ljava/util/function/Predicate;", "folder", "", "resolvablePath", "stringVisitor", "", "visit", "pathVisitor", "path", "visitor", "filter", "onlyIf", "condition", "handler", "Ljava/util/function/Consumer;", "visitFiles", "skipFiles", "visitFolders", "skipFolders", "visitFile", "skipFile", "visitFolder", "skipFolder", "onVisit", "Ljava/nio/file/FileVisitResult;", "Lorg/kingdoms/utils/fs/walker/visitors/PathVisit;", "shared"})
@SourceDebugExtension(value={"SMAP\nFunctionalPathVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionalPathVisitor.kt\norg/kingdoms/utils/fs/walker/visitors/FunctionalPathVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,67:1\n1863#2,2:68\n1#3:70\n*S KotlinDebug\n*F\n+ 1 FunctionalPathVisitor.kt\norg/kingdoms/utils/fs/walker/visitors/FunctionalPathVisitor\n*L\n17#1:68,2\n*E\n"})
public final class FunctionalPathVisitor
implements PathVisitor {
    @NotNull
    private final Path root;
    @NotNull
    private List<ConditionalPathVisitor> visitors;

    public FunctionalPathVisitor(@NotNull Path root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.root = root;
        this.visitors = new ArrayList();
    }

    @NotNull
    public final Path getRoot() {
        return this.root;
    }

    @NotNull
    public final List<ConditionalPathVisitor> getVisitors() {
        return this.visitors;
    }

    public final void setVisitors(@NotNull List<ConditionalPathVisitor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.visitors = list;
    }

    private final Predicate<Path> getPathPredicate(boolean folder, Path resolvablePath) {
        return folder ? (Predicate)new StartsWithPathFilter(resolvablePath) : (Predicate)new ExactPathFilter(resolvablePath);
    }

    private final FunctionalPathVisitor stringVisitor(boolean folder, String resolvablePath, boolean visit) {
        Path exactPath = null;
        exactPath = this.root;
        char[] cArray = new char[]{'/'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)resolvablePath, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            exactPath = this.root.resolve(it);
        }
        return this.visitor(folder, this.getPathPredicate(folder, exactPath), visit);
    }

    private final FunctionalPathVisitor pathVisitor(boolean folder, Path path, boolean visit) {
        if (!path.startsWith(this.root)) {
            boolean bl = false;
            String string = "Given path '" + path + "' isn't included in the root path '" + this.root + '\'';
            throw new IllegalArgumentException(string.toString());
        }
        return this.visitor(folder, this.getPathPredicate(folder, path), visit);
    }

    private final FunctionalPathVisitor visitor(boolean folder, Predicate<Path> filter, boolean visit) {
        ConditionalPathVisitor handle2 = new ConditionalPathVisitor(filter, visit ? (PathVisitor)VisitAll.INSTANCE : (PathVisitor)SkipAll.INSTANCE);
        this.visitors.add(handle2);
        return this;
    }

    @NotNull
    public final FunctionalPathVisitor onlyIf(boolean condition, @NotNull Consumer<FunctionalPathVisitor> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        if (condition) {
            handler.accept(this);
        }
        return this;
    }

    @NotNull
    public final FunctionalPathVisitor visitFiles(@NotNull Predicate<Path> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return this.visitor(false, filter, true);
    }

    @NotNull
    public final FunctionalPathVisitor skipFiles(@NotNull Predicate<Path> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return this.visitor(false, filter, true);
    }

    @NotNull
    public final FunctionalPathVisitor visitFolders(@NotNull Predicate<Path> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return this.visitor(true, filter, true);
    }

    @NotNull
    public final FunctionalPathVisitor skipFolders(@NotNull Predicate<Path> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        return this.visitor(true, filter, true);
    }

    @NotNull
    public final FunctionalPathVisitor visitFile(@NotNull String resolvablePath) {
        Intrinsics.checkNotNullParameter((Object)resolvablePath, (String)"resolvablePath");
        return this.stringVisitor(false, resolvablePath, true);
    }

    @NotNull
    public final FunctionalPathVisitor skipFile(@NotNull String resolvablePath) {
        Intrinsics.checkNotNullParameter((Object)resolvablePath, (String)"resolvablePath");
        return this.stringVisitor(false, resolvablePath, false);
    }

    @NotNull
    public final FunctionalPathVisitor visitFolder(@NotNull String resolvablePath) {
        Intrinsics.checkNotNullParameter((Object)resolvablePath, (String)"resolvablePath");
        return this.stringVisitor(true, resolvablePath, true);
    }

    @NotNull
    public final FunctionalPathVisitor skipFolder(@NotNull String resolvablePath) {
        Intrinsics.checkNotNullParameter((Object)resolvablePath, (String)"resolvablePath");
        return this.stringVisitor(true, resolvablePath, false);
    }

    @NotNull
    public final FunctionalPathVisitor visitFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.pathVisitor(false, path, true);
    }

    @NotNull
    public final FunctionalPathVisitor skipFile(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.pathVisitor(false, path, false);
    }

    @NotNull
    public final FunctionalPathVisitor visitFolder(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.pathVisitor(true, path, true);
    }

    @NotNull
    public final FunctionalPathVisitor skipFolder(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.pathVisitor(true, path, false);
    }

    @Override
    @NotNull
    public FileVisitResult onVisit(@NotNull PathVisit visit) {
        Intrinsics.checkNotNullParameter((Object)visit, (String)"visit");
        if (Intrinsics.areEqual((Object)visit.getPath(), (Object)this.root)) {
            return FileVisitResult.CONTINUE;
        }
        for (ConditionalPathVisitor pathVisitHandle : this.visitors) {
            if (!pathVisitHandle.getPredicate().test(visit.getPath())) continue;
            return pathVisitHandle.getVisitor().onVisit(visit);
        }
        return FileVisitResult.SKIP_SUBTREE;
    }
}

