/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.fs.walker;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemLoopException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kingdoms.utils.fs.walker.FileTreeIterator;
import org.kingdoms.utils.fs.walker.FileWalkerController;
import org.kingdoms.utils.fs.walker.visitors.PathVisit;
import org.kingdoms.utils.fs.walker.visitors.PathVisitor;

public class FileTreeWalker
implements Closeable,
FileWalkerController {
    private final boolean followLinks;
    private final LinkOption[] linkOptions;
    private final int maxDepth;
    private final ArrayDeque<DirectoryNode> stack = new ArrayDeque();
    private boolean closed;

    public static Stream<PathVisit> walk(Path start, Set<FileVisitOption> options, int maxDepth, AtomicReference<FileWalkerController> controller) throws IOException {
        FileTreeIterator iterator = new FileTreeIterator(start, maxDepth, options.toArray(new FileVisitOption[0]));
        controller.set(iterator);
        try {
            Spliterator<PathVisit> spliterator = Spliterators.spliteratorUnknownSize(iterator, 1);
            return (Stream)StreamSupport.stream(spliterator, false).onClose(iterator::close);
        }
        catch (Error | RuntimeException ex) {
            iterator.close();
            throw ex;
        }
    }

    public static void walkFileTree(Path start, Set<FileVisitOption> options, int maxDepth, PathVisitor visitor) {
        try (FileTreeWalker walker = new FileTreeWalker(options, maxDepth);){
            PathVisit ev = walker.walk(start);
            do {
                FileVisitResult result;
                switch (ev.getVisitType()) {
                    case ENTRY: {
                        result = visitor.onVisit(ev);
                        break;
                    }
                    case START_DIRECTORY: {
                        FileVisitResult res = visitor.onVisit(ev);
                        if (res == FileVisitResult.SKIP_SUBTREE || res == FileVisitResult.SKIP_SIBLINGS) {
                            walker.skipDirectory();
                        }
                        result = res;
                        break;
                    }
                    case END_DIRECTORY: {
                        FileVisitResult res = visitor.onVisit(ev);
                        if (res == FileVisitResult.SKIP_SIBLINGS) {
                            res = FileVisitResult.CONTINUE;
                        }
                        result = res;
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Should not get here: " + (Object)((Object)ev.getVisitType())));
                    }
                }
                if (Objects.requireNonNull(result) == FileVisitResult.CONTINUE) continue;
                if (result == FileVisitResult.TERMINATE) {
                    break;
                }
                if (result != FileVisitResult.SKIP_SIBLINGS) continue;
                walker.skipRemainingSiblings();
            } while ((ev = walker.next()) != null);
        }
    }

    FileTreeWalker(Collection<FileVisitOption> options, int maxDepth) {
        LinkOption[] linkOptionArray;
        boolean fl = false;
        block3: for (FileVisitOption option : options) {
            switch (option) {
                case FOLLOW_LINKS: {
                    fl = true;
                    continue block3;
                }
            }
            throw new AssertionError((Object)"Should not get here");
        }
        if (maxDepth < 0) {
            throw new IllegalArgumentException("'maxDepth' is negative");
        }
        this.followLinks = fl;
        if (fl) {
            linkOptionArray = new LinkOption[]{};
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[1];
            linkOptionArray = linkOptionArray2;
            linkOptionArray2[0] = LinkOption.NOFOLLOW_LINKS;
        }
        this.linkOptions = linkOptionArray;
        this.maxDepth = maxDepth;
    }

    private BasicFileAttributes getAttributes(Path file) throws IOException {
        BasicFileAttributes attrs;
        try {
            attrs = Files.readAttributes(file, BasicFileAttributes.class, this.linkOptions);
        }
        catch (IOException ioe) {
            if (!this.followLinks) {
                throw ioe;
            }
            attrs = Files.readAttributes(file, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        return attrs;
    }

    private boolean wouldLoop(Path dir, Object key) {
        for (DirectoryNode ancestor : this.stack) {
            Object ancestorKey = ancestor.key;
            if (key != null && ancestorKey != null) {
                if (!key.equals(ancestorKey)) continue;
                return true;
            }
            try {
                if (!Files.isSameFile(dir, ancestor.dir)) continue;
                return true;
            }
            catch (IOException | SecurityException exception) {
            }
        }
        return false;
    }

    private PathVisit visit(Path entry, boolean ignoreSecurityException, boolean canUseCached) {
        BasicFileAttributes attrs;
        try {
            attrs = this.getAttributes(entry);
        }
        catch (IOException ioe) {
            return new PathVisit(PathVisit.Type.ENTRY, entry, ioe);
        }
        catch (SecurityException se) {
            if (ignoreSecurityException) {
                return null;
            }
            throw se;
        }
        int depth = this.stack.size();
        if (depth >= this.maxDepth || !attrs.isDirectory()) {
            return new PathVisit(PathVisit.Type.ENTRY, entry, attrs);
        }
        if (this.followLinks && this.wouldLoop(entry, attrs.fileKey())) {
            return new PathVisit(PathVisit.Type.ENTRY, entry, new FileSystemLoopException(entry.toString()));
        }
        DirectoryStream<Path> stream = null;
        try {
            stream = Files.newDirectoryStream(entry);
        }
        catch (IOException ioe) {
            return new PathVisit(PathVisit.Type.ENTRY, entry, ioe);
        }
        catch (SecurityException se) {
            if (ignoreSecurityException) {
                return null;
            }
            throw se;
        }
        this.stack.push(new DirectoryNode(entry, attrs.fileKey(), stream));
        return new PathVisit(PathVisit.Type.START_DIRECTORY, entry, attrs);
    }

    PathVisit walk(Path file) {
        if (this.closed) {
            throw new IllegalStateException("Closed");
        }
        PathVisit ev = this.visit(file, false, false);
        assert (ev != null);
        return ev;
    }

    PathVisit next() {
        Path entry;
        PathVisit ev;
        DirectoryNode top = this.stack.peek();
        if (top == null) {
            return null;
        }
        do {
            entry = null;
            IOException ioe = null;
            if (!top.skipped) {
                Iterator iterator = top.iterator;
                try {
                    if (iterator.hasNext()) {
                        entry = (Path)iterator.next();
                    }
                }
                catch (DirectoryIteratorException x) {
                    ioe = x.getCause();
                }
            }
            if (entry != null) continue;
            try {
                top.stream.close();
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                }
                ioe.addSuppressed(e);
            }
            this.stack.pop();
            return new PathVisit(PathVisit.Type.END_DIRECTORY, top.dir, ioe);
        } while ((ev = this.visit(entry, true, true)) == null);
        return ev;
    }

    @Override
    public void skipDirectory() {
        if (!this.stack.isEmpty()) {
            DirectoryNode node = this.stack.pop();
            try {
                node.stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void skipRemainingSiblings() {
        if (!this.stack.isEmpty()) {
            this.stack.peek().skip();
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            while (!this.stack.isEmpty()) {
                this.skipDirectory();
            }
            this.closed = true;
        }
    }

    private static class DirectoryNode {
        private final Path dir;
        private final Object key;
        private final DirectoryStream<Path> stream;
        private final Iterator<Path> iterator;
        private boolean skipped;

        DirectoryNode(Path dir, Object key, DirectoryStream<Path> stream) {
            this.dir = dir;
            this.key = key;
            this.stream = stream;
            this.iterator = stream.iterator();
        }

        void skip() {
            this.skipped = true;
        }
    }
}

