/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.fs.walker;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.kingdoms.utils.fs.walker.FileTreeWalker;
import org.kingdoms.utils.fs.walker.FileWalkerController;
import org.kingdoms.utils.fs.walker.visitors.PathVisit;

class FileTreeIterator
implements Iterator<PathVisit>,
Closeable,
FileWalkerController {
    private final FileTreeWalker walker;
    private PathVisit next;

    FileTreeIterator(Path start, int maxDepth, FileVisitOption ... options) throws IOException {
        this.walker = new FileTreeWalker(Arrays.asList(options), maxDepth);
        this.next = this.walker.walk(start);
        assert (this.next.getVisitType() == PathVisit.Type.ENTRY || this.next.getVisitType() == PathVisit.Type.START_DIRECTORY);
        IOException ioe = this.next.getException();
        if (ioe != null) {
            throw ioe;
        }
    }

    private void fetchNextIfNeeded() {
        if (this.next == null) {
            PathVisit ev = this.walker.next();
            while (ev != null) {
                IOException ioe = ev.getException();
                if (ioe != null) {
                    throw new UncheckedIOException(ioe);
                }
                if (ev.getVisitType() != PathVisit.Type.END_DIRECTORY) {
                    this.next = ev;
                    return;
                }
                ev = this.walker.next();
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.walker.isOpen()) {
            throw new IllegalStateException();
        }
        this.fetchNextIfNeeded();
        return this.next != null;
    }

    @Override
    public PathVisit next() {
        if (!this.walker.isOpen()) {
            throw new IllegalStateException();
        }
        this.fetchNextIfNeeded();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        PathVisit result = this.next;
        this.next = null;
        return result;
    }

    @Override
    public void skipDirectory() {
        this.walker.skipDirectory();
    }

    @Override
    public void skipRemainingSiblings() {
        this.walker.skipRemainingSiblings();
    }

    @Override
    public void close() {
        this.walker.close();
    }
}

