/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.visualizer.visibility;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.entity.Player;
import org.kingdoms.constants.namespace.Namespace;
import org.kingdoms.constants.namespace.NamespacedMap;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.utils.display.visualizer.visibility.ControllingVisibilityListener;
import org.kingdoms.utils.display.visualizer.visibility.PlayerVisibilityEvaluation;
import org.kingdoms.utils.display.visualizer.visibility.VisibilityFilter;
import org.kingdoms.utils.display.visualizer.visibility.VisibilityListener;
import org.kingdoms.utils.display.visualizer.visibility.VisibilitySpecifier;
import org.kingdoms.utils.display.visualizer.visibility.VisibilityState;
import org.kingdoms.utils.display.visualizer.visibility.VisibilityStrategy;
import org.kingdoms.utils.internal.nonnull.NonNullMap;

public abstract class StatefulVisibilityStrategy
implements VisibilityStrategy {
    private static final short CLEAR_PRIORITY = 0;
    @NotNull
    private final Set<VisibilityListener> listeners = Collections.newSetFromMap(new IdentityHashMap(1));
    @NotNull
    private final Map<UUID, PlayerVisibilityEvaluation> visible = new HashMap<UUID, PlayerVisibilityEvaluation>();
    @NotNull
    private final Set<UUID> visibleTo = new HashSet<UUID>();
    public static final AtomicInteger ids = new AtomicInteger();

    private static VisibilitySpecifier getPrioritized(NamespacedMap<VisibilitySpecifier> visibility) {
        VisibilitySpecifier prioritized = null;
        for (VisibilitySpecifier visibile : visibility.values()) {
            if (prioritized == null) {
                prioritized = visibile;
                continue;
            }
            if (visibile.getPriority() >= prioritized.getPriority()) continue;
            prioritized = visibile;
        }
        return prioritized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changePlayerState(Player player, Namespace namespace, VisibilityState state, short priority) {
        NamespacedMap<VisibilitySpecifier> visibility;
        boolean wasNull;
        PlayerVisibilityEvaluation playerVisibility;
        Object object = this.visible;
        synchronized (object) {
            playerVisibility = this.visible.get(player.getUniqueId());
            if (playerVisibility == null) {
                if (state == VisibilityState.NONE) {
                    return;
                }
                wasNull = true;
                visibility = new NamespacedMap(new NonNullMap(3));
                playerVisibility = new PlayerVisibilityEvaluation(state, visibility);
                this.visible.put(player.getUniqueId(), playerVisibility);
            } else {
                wasNull = false;
                visibility = playerVisibility.getStates();
            }
        }
        object = playerVisibility;
        synchronized (object) {
            if (state == VisibilityState.NONE) {
                visibility.remove(namespace);
                if (visibility.isEmpty()) {
                    this.visible.remove(player.getUniqueId());
                }
            } else {
                if (visibility.isEmpty()) {
                    for (VisibilityListener listener : this.listeners) {
                        VisibilityFilter answer;
                        if (!(listener instanceof ControllingVisibilityListener) || (answer = ((ControllingVisibilityListener)listener).shouldExcludePlayer(player)) == null) continue;
                        visibility.put(answer.getNamespace(), answer.getSpecifier());
                    }
                }
                visibility.put(namespace, new VisibilitySpecifier(state, priority));
            }
            VisibilitySpecifier prioritizedVisibility = StatefulVisibilityStrategy.getPrioritized(visibility);
            VisibilityState newState = prioritizedVisibility.getState();
            VisibilityState prevVisibilityState = playerVisibility.getState();
            if (wasNull) {
                playerVisibility.setState(newState);
            }
            if (wasNull && newState != VisibilityState.HIDE || !wasNull && newState != prevVisibilityState) {
                playerVisibility.setState(newState);
                switch (newState) {
                    case SHOW: {
                        if (!this.visibleTo.add(player.getUniqueId())) {
                            throw new AssertionError((Object)("Already visible to " + player + " from: (wasNull=" + wasNull + ") " + (Object)((Object)prevVisibilityState) + " -> " + (Object)((Object)newState)));
                        }
                        for (VisibilityListener listener : this.listeners) {
                            listener.onPlayerAdd(player);
                        }
                        break;
                    }
                    case HIDE: {
                        if (!this.visibleTo.remove(player.getUniqueId())) {
                            throw new AssertionError((Object)("Already invisible to " + player + " from: (wasNull=" + wasNull + ") " + (Object)((Object)prevVisibilityState) + " -> " + (Object)((Object)newState)));
                        }
                        for (VisibilityListener listener : this.listeners) {
                            listener.onPlayerRemove(player);
                        }
                        break;
                    }
                    case NONE: {
                        throw new AssertionError((Object)("Found State::NONE for " + player + " while handling " + visibility));
                    }
                    default: {
                        throw new AssertionError((Object)("Unknown visibility state: " + (Object)((Object)newState)));
                    }
                }
            }
        }
    }

    @Override
    @NotNull
    public final Set<VisibilityListener> getListeners() {
        return this.listeners;
    }

    @Override
    @NotNull
    public Set<UUID> getVisibleTo() {
        return this.visibleTo;
    }

    public final void showTo(@NotNull Player player, @NotNull Namespace namespace, short priority) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(namespace, "namespace");
        this.changePlayerState(player, namespace, VisibilityState.SHOW, priority);
    }

    public final void hideFrom(@NotNull Player player, @NotNull Namespace namespace, short priority) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(namespace, "namespace");
        this.changePlayerState(player, namespace, VisibilityState.HIDE, priority);
    }

    public final void clearState(@NotNull Player player, @NotNull Namespace namespace) {
        Objects.requireNonNull(player, "player");
        Objects.requireNonNull(namespace, "namespace");
        this.changePlayerState(player, namespace, VisibilityState.NONE, (short)0);
    }

    @Override
    public void registerListener(@NotNull VisibilityListener visibilityListener) {
        Objects.requireNonNull(visibilityListener, "visibilityListener");
        this.listeners.add(visibilityListener);
    }

    @Override
    public void unregisterListener(@NotNull VisibilityListener visibilityListener) {
        Objects.requireNonNull(visibilityListener, "visibilityListener");
        this.listeners.remove(visibilityListener);
    }
}

