/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.visualizer;

import java.time.Duration;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.scheduler.ScheduledTask;
import org.kingdoms.utils.display.components.VisualComponent;
import org.kingdoms.utils.display.visualizer.AbstractVisualizer;
import org.kingdoms.utils.display.visualizer.visibility.StatefulVisibilityStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/utils/display/visualizer/TemporaryVisualizer;", "Lorg/kingdoms/utils/display/visualizer/AbstractVisualizer;", "visibilityStrategy", "Lorg/kingdoms/utils/display/visualizer/visibility/StatefulVisibilityStrategy;", "duration", "Ljava/time/Duration;", "messageContext", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "<init>", "(Lorg/kingdoms/utils/display/visualizer/visibility/StatefulVisibilityStrategy;Ljava/time/Duration;Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;)V", "getDuration", "()Ljava/time/Duration;", "getMessageContext", "()Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "stopTask", "Lorg/kingdoms/scheduler/ScheduledTask;", "getStopTask", "()Lorg/kingdoms/scheduler/ScheduledTask;", "setStopTask", "(Lorg/kingdoms/scheduler/ScheduledTask;)V", "start", "", "checkedStop", "stop", "core"})
public class TemporaryVisualizer
extends AbstractVisualizer {
    @NotNull
    private final Duration duration;
    @NotNull
    private final MessagePlaceholderProvider messageContext;
    public ScheduledTask stopTask;

    public TemporaryVisualizer(@NotNull StatefulVisibilityStrategy visibilityStrategy, @NotNull Duration duration, @NotNull MessagePlaceholderProvider messageContext) {
        Intrinsics.checkNotNullParameter((Object)visibilityStrategy, (String)"visibilityStrategy");
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)messageContext, (String)"messageContext");
        super(visibilityStrategy);
        this.duration = duration;
        this.messageContext = messageContext;
    }

    @NotNull
    public final Duration getDuration() {
        return this.duration;
    }

    @Override
    @NotNull
    public MessagePlaceholderProvider getMessageContext() {
        return this.messageContext;
    }

    @NotNull
    public final ScheduledTask getStopTask() {
        ScheduledTask scheduledTask = this.stopTask;
        if (scheduledTask != null) {
            return scheduledTask;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stopTask");
        return null;
    }

    public final void setStopTask(@NotNull ScheduledTask scheduledTask) {
        Intrinsics.checkNotNullParameter((Object)scheduledTask, (String)"<set-?>");
        this.stopTask = scheduledTask;
    }

    @Override
    public void start() {
        super.start();
        this.setStopTask(Kingdoms.taskScheduler().async().delayed(this.duration, this::checkedStop));
    }

    private final void checkedStop() {
        if (this.getState() == VisualComponent.State.STARTED) {
            this.stop();
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.getStopTask().cancel();
    }
}

