/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.scoreboard;

import com.google.common.collect.MapMaker;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftConnection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.display.scoreboard.GlowScoreboard;

public final class Glow
implements Listener {
    private static final Map<Integer, Entity> ENTITY_ID_MAPPING;
    private static final Map<UUID, Set<Entity>> GLOWS;
    private static final Map<UUID, Set<Player>> GLOWING_FOR;
    private static final boolean isPaper;
    static Class<?> DataWatcher;
    static Class<?> DataWatcherItem;
    private static final Class<?> DATA_WATCHER_ITEMS_TYPE;
    private static final Class<?> PacketPlayOutEntityMetadata;
    private static final Class<?> Entity;

    public static void setGlowing(Player receiver, GlowScoreboard.Color color, Entity ... members) {
        Objects.requireNonNull(members);
        Objects.requireNonNull(receiver);
        Set glows = GLOWS.computeIfAbsent(receiver.getUniqueId(), k -> new HashSet());
        glows.addAll(Arrays.asList(members));
        Set glowFor = GLOWING_FOR.computeIfAbsent(receiver.getUniqueId(), k -> new HashSet());
        glowFor.add(receiver);
        for (Entity entity2 : members) {
            Glow.sendGlowPacket(receiver, true, entity2);
        }
        new GlowScoreboard().setColor(color).setMembers(Arrays.asList(members)).build().setScoreboard(receiver);
    }

    public static void removeGlow(Player receiver) {
        Objects.requireNonNull(receiver);
        Set<Entity> entities = GLOWS.remove(receiver.getUniqueId());
        for (Entity entity2 : entities) {
            Glow.sendGlowPacket(receiver, false, entity2);
        }
    }

    public static boolean isGlowing(Entity entity2, Player receiver) {
        Set<Player> glows = GLOWING_FOR.get(entity2.getUniqueId());
        return glows != null && glows.contains(receiver);
    }

    private static byte magicGlowIndex(boolean glowing, byte flags) {
        return (byte)(glowing ? flags | 0x40 : flags & 0xFFFFFFBF);
    }

    public static void glowBlock(Location location) {
        MagmaCube entity2 = (MagmaCube)location.getWorld().spawnEntity(location, EntityType.MAGMA_CUBE);
        entity2.setGlowing(true);
        entity2.setInvisible(true);
    }

    protected static void sendGlowPacket(Player receiver, boolean glowing, Entity entity2) {
        try {
            Object packetMetadata;
            ENTITY_ID_MAPPING.put(entity2.getEntityId(), entity2);
            Method handle2 = entity2.getClass().getDeclaredMethod("getHandle", new Class[0]);
            Object dataWatcher = Entity.getDeclaredMethod("getDataWatcher", new Class[0]).invoke(handle2.invoke((Object)entity2, new Object[0]), new Object[0]);
            Map dataWatcherItems = (Map)Glow.resolveByLastType(DataWatcher, DATA_WATCHER_ITEMS_TYPE).get(dataWatcher);
            Field field = null;
            for (Field fieldloop : Entity.getDeclaredFields()) {
                if (!"DataWatcherObject".equals(fieldloop.getType().getSimpleName())) continue;
                field = fieldloop;
                break;
            }
            field.setAccessible(true);
            Object dataWatcherObject = field.get(null);
            field = DataWatcherItem.getDeclaredField("b");
            field.setAccessible(true);
            byte flags = (Byte)(dataWatcherItems.isEmpty() ? Integer.valueOf(0) : field.get(dataWatcherItems.get(0)));
            byte newFlags = Glow.magicGlowIndex(glowing, flags);
            Object dataWatcherItem = DataWatcherItem.getConstructors()[0].newInstance(dataWatcherObject, newFlags);
            if (XReflection.supports((int)17)) {
                packetMetadata = PacketPlayOutEntityMetadata.getConstructor(Integer.TYPE, DataWatcher, Boolean.TYPE).newInstance(-entity2.getEntityId(), dataWatcher, true);
                field = PacketPlayOutEntityMetadata.getDeclaredField("b");
                field.setAccessible(true);
                List dataWatcherList = (List)field.get(packetMetadata);
                dataWatcherList.clear();
                dataWatcherList.add(dataWatcherItem);
            } else {
                packetMetadata = PacketPlayOutEntityMetadata.newInstance();
                field = PacketPlayOutEntityMetadata.getDeclaredField("a");
                field.setAccessible(true);
                field.set(packetMetadata, -entity2.getEntityId());
                ArrayList list = new ArrayList(8);
                list.add(dataWatcherItem);
                field = PacketPlayOutEntityMetadata.getDeclaredField("b");
                field.setAccessible(true);
                field.set(packetMetadata, list);
            }
            MinecraftConnection.sendPacket((Player)receiver, (Object[])new Object[]{packetMetadata});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field resolveByLastType(Class<?> clazz, Class<?> type) throws ReflectiveOperationException {
        Field field = null;
        for (Field field1 : clazz.getDeclaredFields()) {
            if (field1.getType() != type) continue;
            field = field1;
        }
        if (field == null) {
            throw new NoSuchFieldException("Could not resolve field of type '" + type.toString() + "' in class " + clazz);
        }
        field.setAccessible(true);
        return field;
    }

    static {
        boolean paper;
        ENTITY_ID_MAPPING = new MapMaker().weakValues().makeMap();
        GLOWS = new HashMap<UUID, Set<Entity>>();
        GLOWING_FOR = new HashMap<UUID, Set<Player>>();
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            paper = true;
        }
        catch (Exception ignored) {
            paper = false;
        }
        isPaper = paper;
        PacketPlayOutEntityMetadata = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").named(new String[]{"PacketPlayOutEntityMetadata"}).unreflect();
        DataWatcher = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").named(new String[]{"DataWatcher"}).unreflect();
        DataWatcherItem = XReflection.getNMSClass((String)"network.syncher", (String)"DataWatcher$Item");
        Entity = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").named(new String[]{"Entity"}).unreflect();
        Class dataWatcherItemsType = null;
        try {
            dataWatcherItemsType = !XReflection.supports((int)14) ? Map.class : (!XReflection.supports((int)17) ? (isPaper ? Class.forName("org.kingdoms.utils.internal.fastutil.Int2ObjectOpenHashMap") : Class.forName("org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap")) : (isPaper ? Class.forName("it.unimi.dsi.fastutil.ints.Int2ObjectMap") : Class.forName("org.bukkit.craftbukkit.libs.it.unimi.dsi.fastutil.ints.Int2ObjectMap")));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        DATA_WATCHER_ITEMS_TYPE = dataWatcherItemsType;
        KLogger.error("Protocol channels opened unexpectedly");
        throw new IllegalStateException();
    }
}

