/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.plugin.Plugin;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.holograms.GroupedHologram;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.display.models.EntityModelState;
import org.kingdoms.utils.display.models.HologramVisualModel;
import org.kingdoms.utils.display.models.TextDisplayEntitySettings;
import org.kingdoms.utils.versionsupport.VersionSupport;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0006\u0010\u0016\u001a\u00020\u0011J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u000eH\u0014J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u001bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/kingdoms/utils/display/models/TextDisplayEntityVisualModel;", "Lorg/kingdoms/utils/display/models/HologramVisualModel;", "holograms", "", "Lorg/kingdoms/managers/holograms/GroupedHologram;", "<init>", "(Ljava/util/Collection;)V", "activeHolograms", "", "Lorg/kingdoms/utils/display/models/TextDisplayEntityVisualModel$SpawnedHologram;", "getActiveHolograms", "()Ljava/util/List;", "entities", "", "Lorg/bukkit/entity/Entity;", "getEntities", "remove", "", "addPlayer", "player", "Lorg/bukkit/entity/Player;", "removePlayer", "remove0", "initials", "entity", "update", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "spawn", "origin", "Lorg/kingdoms/server/location/Location;", "spawn0", "SpawnedHologram", "core"})
@SourceDebugExtension(value={"SMAP\nEntityVisualModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityVisualModel.kt\norg/kingdoms/utils/display/models/TextDisplayEntityVisualModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1557#2:312\n1628#2,3:313\n1863#2,2:316\n1863#2,2:318\n1863#2,2:320\n1863#2,2:322\n*S KotlinDebug\n*F\n+ 1 EntityVisualModel.kt\norg/kingdoms/utils/display/models/TextDisplayEntityVisualModel\n*L\n132#1:312\n132#1:313,3\n143#1:316,2\n148#1:318,2\n152#1:320,2\n167#1:322,2\n*E\n"})
public final class TextDisplayEntityVisualModel
extends HologramVisualModel {
    @NotNull
    private final List<SpawnedHologram> activeHolograms;

    public TextDisplayEntityVisualModel(@NotNull Collection<GroupedHologram> holograms) {
        Intrinsics.checkNotNullParameter(holograms, (String)"holograms");
        super(holograms);
        this.activeHolograms = new CopyOnWriteArrayList();
    }

    @NotNull
    public final List<SpawnedHologram> getActiveHolograms() {
        return this.activeHolograms;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Entity> getEntities() {
        void $this$mapTo$iv$iv;
        this.ensure(EntityModelState.SPAWNED);
        Iterable $this$map$iv = this.activeHolograms;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SpawnedHologram spawnedHologram = (SpawnedHologram)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEntity());
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void remove() {
        this.ensure(EntityModelState.SPAWNED);
        if (Bukkit.isPrimaryThread()) {
            this.remove0();
        } else {
            Kingdoms.taskScheduler().sync().execute(() -> TextDisplayEntityVisualModel.remove$lambda$1(this));
        }
    }

    @Override
    public void addPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.addPlayer(player);
        Iterable $this$forEach$iv = this.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            player.showEntity((Plugin)Kingdoms.get(), it);
        }
    }

    @Override
    public void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.removePlayer(player);
        Iterable $this$forEach$iv = this.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            player.hideEntity((Plugin)Kingdoms.get(), it);
        }
    }

    public final void remove0() {
        Iterable $this$forEach$iv = this.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Entity it = (Entity)element$iv;
            boolean bl = false;
            it.remove();
        }
        this.activeHolograms.clear();
        this.setState(EntityModelState.REMOVED);
    }

    @Override
    protected void initials(@NotNull Entity entity2) {
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        super.initials(entity2);
        entity2.setPersistent(false);
        entity2.setVisibleByDefault(false);
        TextDisplay it = (TextDisplay)entity2;
        boolean bl = false;
        it.setAlignment(TextDisplay.TextAlignment.CENTER);
        it.setBillboard(Display.Billboard.CENTER);
        it.setSeeThrough(false);
        Iterable $this$forEach$iv = this.getOnlineVisitors();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it2 = (Player)element$iv;
            boolean bl2 = false;
            it2.showEntity((Plugin)Kingdoms.get(), entity2);
        }
    }

    @Override
    public void update(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensure(EntityModelState.SPAWNED);
        for (SpawnedHologram activeHologram : this.activeHolograms) {
            Messenger message = activeHologram.getGroup().getHologram().getSettings().getMessage();
            activeHologram.getEntity().setText(message.parse(context));
        }
    }

    @Override
    public void spawn(@NotNull Location origin, @NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensure(EntityModelState.NOT_SPAWNED);
        if (Bukkit.isPrimaryThread()) {
            this.spawn0(origin, context);
        } else {
            Kingdoms.taskScheduler().sync().execute(() -> TextDisplayEntityVisualModel.spawn$lambda$7(this, origin, context));
        }
    }

    public final void spawn0(@NotNull Location origin, @NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Location currentOffset = origin;
        for (GroupedHologram hologram : this.getHolograms()) {
            TextDisplayEntitySettings textDisplayEntitySettings;
            org.bukkit.Location bukkitLoc;
            currentOffset = currentOffset.add(hologram.getOffset());
            Intrinsics.checkNotNull((Object)BukkitAdapter.adapt(currentOffset));
            TextDisplay entity2 = (TextDisplay)VersionSupport.spawn(bukkitLoc, TextDisplay.class, arg_0 -> TextDisplayEntityVisualModel.spawn0$lambda$8((Function1)new Function1<Entity, Unit>((Object)this){

                public final void invoke(Entity p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    ((TextDisplayEntityVisualModel)this.receiver).initials(p0);
                }
            }, arg_0));
            Intrinsics.checkNotNull((Object)entity2);
            this.initials((Entity)entity2);
            TextDisplayEntitySettings $this$spawn0_u24lambda_u249 = textDisplayEntitySettings = hologram.getHologram().getSettings();
            boolean bl = false;
            if ($this$spawn0_u24lambda_u249.getAlignment() != null) {
                entity2.setAlignment($this$spawn0_u24lambda_u249.getAlignment().getBukkit());
            }
            if ($this$spawn0_u24lambda_u249.getHeight() != null) {
                entity2.setDisplayHeight($this$spawn0_u24lambda_u249.getHeight().floatValue());
            }
            if ($this$spawn0_u24lambda_u249.getWidth() != null) {
                entity2.setDisplayWidth($this$spawn0_u24lambda_u249.getWidth().floatValue());
            }
            if ($this$spawn0_u24lambda_u249.getViewRange() != null) {
                entity2.setViewRange($this$spawn0_u24lambda_u249.getViewRange().floatValue());
            }
            if ($this$spawn0_u24lambda_u249.getTextOpacity() != null) {
                entity2.setTextOpacity($this$spawn0_u24lambda_u249.getTextOpacity().byteValue());
            }
            if ($this$spawn0_u24lambda_u249.getShadowText() != null) {
                entity2.setShadowed($this$spawn0_u24lambda_u249.getShadowText().booleanValue());
            }
            if ($this$spawn0_u24lambda_u249.getShadow() != null) {
                entity2.setShadowStrength($this$spawn0_u24lambda_u249.getShadow().getStrength());
                entity2.setShadowRadius($this$spawn0_u24lambda_u249.getShadow().getRadius());
            }
            if ($this$spawn0_u24lambda_u249.getBrightness() != null) {
                entity2.setBrightness(new Display.Brightness($this$spawn0_u24lambda_u249.getBrightness().getBlockLight(), $this$spawn0_u24lambda_u249.getBrightness().getSkyLight()));
            }
            if ($this$spawn0_u24lambda_u249.getBackgroundColor() != null) {
                entity2.setBackgroundColor(BukkitAdapter.adapt($this$spawn0_u24lambda_u249.getBackgroundColor()));
            }
            if ($this$spawn0_u24lambda_u249.getGlow() != null) {
                entity2.setGlowing(true);
                entity2.setGlowColorOverride(BukkitAdapter.adapt($this$spawn0_u24lambda_u249.getGlow()));
            }
            entity2.setText($this$spawn0_u24lambda_u249.getMessage().parse(context));
            this.activeHolograms.add(new SpawnedHologram(entity2, hologram));
        }
        this.setState(EntityModelState.SPAWNED);
    }

    private static final void remove$lambda$1(TextDisplayEntityVisualModel this$0) {
        this$0.remove0();
    }

    private static final void spawn$lambda$7(TextDisplayEntityVisualModel this$0, Location $origin, MessagePlaceholderProvider $context) {
        this$0.spawn0($origin, $context);
    }

    private static final void spawn0$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/kingdoms/utils/display/models/TextDisplayEntityVisualModel$SpawnedHologram;", "", "entity", "Lorg/bukkit/entity/TextDisplay;", "group", "Lorg/kingdoms/managers/holograms/GroupedHologram;", "<init>", "(Lorg/bukkit/entity/TextDisplay;Lorg/kingdoms/managers/holograms/GroupedHologram;)V", "getEntity", "()Lorg/bukkit/entity/TextDisplay;", "getGroup", "()Lorg/kingdoms/managers/holograms/GroupedHologram;", "core"})
    public static final class SpawnedHologram {
        @NotNull
        private final TextDisplay entity;
        @NotNull
        private final GroupedHologram group;

        public SpawnedHologram(@NotNull TextDisplay entity2, @NotNull GroupedHologram group) {
            Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            this.entity = entity2;
            this.group = group;
        }

        @NotNull
        public final TextDisplay getEntity() {
            return this.entity;
        }

        @NotNull
        public final GroupedHologram getGroup() {
            return this.group;
        }
    }
}

