/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.models;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Rotatable;
import org.bukkit.entity.BlockDisplay;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.land.building.info.block.BlockInfo;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Unit;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.text.StringsKt;
import org.kingdoms.libs.xseries.XMaterial;
import org.kingdoms.libs.xseries.profiles.builder.XSkull;
import org.kingdoms.libs.xseries.profiles.objects.Profileable;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.platform.bukkit.adapters.BukkitAdapter;
import org.kingdoms.server.location.Direction;
import org.kingdoms.server.location.Location;
import org.kingdoms.utils.display.models.EntityModelState;
import org.kingdoms.utils.display.models.EntityVisualModel;
import org.kingdoms.utils.versionsupport.VersionSupport;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/kingdoms/utils/display/models/StructureVisualModel;", "Lorg/kingdoms/utils/display/models/EntityVisualModel;", "blocks", "", "Lorg/bukkit/Location;", "Lorg/kingdoms/constants/land/building/info/block/BlockInfo;", "<init>", "(Ljava/util/Map;)V", "getBlocks", "()Ljava/util/Map;", "entities", "", "Lorg/bukkit/entity/Display;", "getEntities", "()Ljava/util/List;", "remove", "", "spawn", "origin", "Lorg/kingdoms/server/location/Location;", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "addPlayer", "player", "Lorg/bukkit/entity/Player;", "removePlayer", "spawn0", "update", "core"})
@SourceDebugExtension(value={"SMAP\nEntityVisualModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EntityVisualModel.kt\norg/kingdoms/utils/display/models/StructureVisualModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1863#2,2:312\n1863#2,2:314\n1863#2,2:316\n1863#2,2:318\n1863#2,2:320\n*S KotlinDebug\n*F\n+ 1 EntityVisualModel.kt\norg/kingdoms/utils/display/models/StructureVisualModel\n*L\n69#1:312,2\n83#1:314,2\n88#1:316,2\n115#1:318,2\n70#1:320,2\n*E\n"})
public final class StructureVisualModel
extends EntityVisualModel {
    @NotNull
    private final Map<org.bukkit.Location, BlockInfo> blocks;
    @NotNull
    private final List<Display> entities;

    public StructureVisualModel(@NotNull Map<org.bukkit.Location, ? extends BlockInfo> blocks) {
        Intrinsics.checkNotNullParameter(blocks, (String)"blocks");
        this.blocks = blocks;
        this.entities = new ArrayList();
    }

    @NotNull
    public final Map<org.bukkit.Location, BlockInfo> getBlocks() {
        return this.blocks;
    }

    @NotNull
    public List<Display> getEntities() {
        return this.entities;
    }

    @Override
    public void remove() {
        this.ensure(EntityModelState.SPAWNED);
        if (Bukkit.isPrimaryThread()) {
            Iterable $this$forEach$iv = this.getEntities();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Display it = (Display)element$iv;
                boolean bl = false;
                it.remove();
            }
        } else {
            Kingdoms.taskScheduler().sync().execute(() -> StructureVisualModel.remove$lambda$2(this));
        }
        this.setState(EntityModelState.REMOVED);
    }

    @Override
    public void spawn(@NotNull Location origin, @NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.ensure(EntityModelState.NOT_SPAWNED);
        if (Bukkit.isPrimaryThread()) {
            this.spawn0(origin);
        } else {
            Kingdoms.taskScheduler().sync().execute(() -> StructureVisualModel.spawn$lambda$3(this, origin));
        }
        this.setState(EntityModelState.SPAWNED);
    }

    @Override
    public void addPlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.addPlayer(player);
        Iterable $this$forEach$iv = this.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Display it = (Display)element$iv;
            boolean bl = false;
            player.showEntity((Plugin)Kingdoms.get(), (Entity)it);
        }
    }

    @Override
    public void removePlayer(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.removePlayer(player);
        Iterable $this$forEach$iv = this.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Display it = (Display)element$iv;
            boolean bl = false;
            player.hideEntity((Plugin)Kingdoms.get(), (Entity)it);
        }
    }

    public final void spawn0(@NotNull Location origin) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        for (Map.Entry<org.bukkit.Location, BlockInfo> entry : this.blocks.entrySet()) {
            XMaterial material;
            org.bukkit.Location key = entry.getKey();
            BlockInfo value = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)XMaterial.matchXMaterial((Material)value.getBlockData().getMaterial()), (String)"matchXMaterial(...)");
            String string = material.name();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-name>(...)");
            Display display = StringsKt.endsWith$default((String)string, (String)"_HEAD", (boolean)false, (int)2, null) ? (Display)VersionSupport.spawn(key.clone().add(0.5, 0.5, 0.5), ItemDisplay.class, arg_0 -> StructureVisualModel.spawn0$lambda$7(arg_0 -> StructureVisualModel.spawn0$lambda$6(value, arg_0), arg_0)) : (Display)VersionSupport.spawn(key, BlockDisplay.class, arg_0 -> StructureVisualModel.spawn0$lambda$9(arg_0 -> StructureVisualModel.spawn0$lambda$8(value, arg_0), arg_0));
            Iterable $this$forEach$iv = this.getOnlineVisitors();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                it.showEntity((Plugin)Kingdoms.get(), (Entity)display);
            }
            List<Display> list = this.getEntities();
            Intrinsics.checkNotNull((Object)display);
            list.add(display);
        }
    }

    @Override
    public void update(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        throw new UnsupportedOperationException();
    }

    private static final void remove$lambda$2(StructureVisualModel this$0) {
        Iterable $this$forEach$iv = this$0.getEntities();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Display it = (Display)element$iv;
            boolean bl = false;
            it.remove();
        }
    }

    private static final void spawn$lambda$3(StructureVisualModel this$0, Location $origin) {
        this$0.spawn0($origin);
    }

    private static final Unit spawn0$lambda$6(BlockInfo $value, ItemDisplay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = XSkull.createItem().profile(Profileable.of((BlockState)$value.getBlockData().createBlockState())).lenient().apply();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apply(...)");
        ItemStack itemStack = (ItemStack)object;
        if ($value.getBlockData() instanceof Rotatable) {
            BlockData blockData = $value.getBlockData();
            Intrinsics.checkNotNull((Object)blockData, (String)"null cannot be cast to non-null type org.bukkit.block.data.Rotatable");
            BlockFace blockFace = ((Rotatable)blockData).getRotation();
            Intrinsics.checkNotNullExpressionValue((Object)blockFace, (String)"getRotation(...)");
            BlockFace rotation = blockFace;
            Direction direction = BukkitAdapter.adapt(rotation);
            it.setRotation(direction.getYaw(), direction.getPitch());
        }
        it.setItemStack(itemStack);
        it.setVisibleByDefault(false);
        it.setPersistent(false);
        return Unit.INSTANCE;
    }

    private static final void spawn0$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit spawn0$lambda$8(BlockInfo $value, BlockDisplay it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.setBlock($value.getBlockData());
        it.setVisibleByDefault(false);
        return Unit.INSTANCE;
    }

    private static final void spawn0$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

