/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.display.components;

import java.time.Duration;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.particles.ParticleDisplay;
import org.kingdoms.scheduler.TaskThreadType;
import org.kingdoms.utils.display.components.UpdatingVisualComponent;
import org.kingdoms.utils.display.visualizer.Visualizer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lorg/kingdoms/utils/display/components/ParticleVisualComponent;", "Lorg/kingdoms/utils/display/components/UpdatingVisualComponent;", "visualizer", "Lorg/kingdoms/utils/display/visualizer/Visualizer;", "updateInterval", "Ljava/time/Duration;", "particleDisplay", "Lorg/kingdoms/libs/xseries/particles/ParticleDisplay;", "particleShape", "Ljava/util/function/Consumer;", "<init>", "(Lorg/kingdoms/utils/display/visualizer/Visualizer;Ljava/time/Duration;Lcom/cryptomorin/xseries/particles/ParticleDisplay;Ljava/util/function/Consumer;)V", "getParticleDisplay", "()Lcom/cryptomorin/xseries/particles/ParticleDisplay;", "getParticleShape", "()Ljava/util/function/Consumer;", "onPlayerAdd", "", "player", "Lorg/bukkit/entity/Player;", "onPlayerRemove", "update", "core"})
public class ParticleVisualComponent
extends UpdatingVisualComponent {
    @NotNull
    private final ParticleDisplay particleDisplay;
    @NotNull
    private final Consumer<ParticleDisplay> particleShape;

    public ParticleVisualComponent(@NotNull Visualizer visualizer, @NotNull Duration updateInterval, @NotNull ParticleDisplay particleDisplay, @NotNull Consumer<ParticleDisplay> particleShape) {
        Intrinsics.checkNotNullParameter((Object)visualizer, (String)"visualizer");
        Intrinsics.checkNotNullParameter((Object)updateInterval, (String)"updateInterval");
        Intrinsics.checkNotNullParameter((Object)particleDisplay, (String)"particleDisplay");
        Intrinsics.checkNotNullParameter(particleShape, (String)"particleShape");
        super(TaskThreadType.ANY, TaskThreadType.ASYNC, visualizer, updateInterval);
        this.particleDisplay = particleDisplay;
        this.particleShape = particleShape;
    }

    @NotNull
    public final ParticleDisplay getParticleDisplay() {
        return this.particleDisplay;
    }

    @NotNull
    public final Consumer<ParticleDisplay> getParticleShape() {
        return this.particleShape;
    }

    @Override
    public void onPlayerAdd(@NotNull Player player) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerAdd(player);
        if (this.particleDisplay.getPlayers() == null) {
            Player[] playerArray = new Player[]{player};
            bl = this.particleDisplay.onlyVisibleTo(playerArray);
        } else {
            Set set = this.particleDisplay.getPlayers();
            Intrinsics.checkNotNull((Object)set);
            bl = set.add(player);
        }
    }

    @Override
    public void onPlayerRemove(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        super.onPlayerRemove(player);
        if (this.particleDisplay.getPlayers() != null) {
            Set set = this.particleDisplay.getPlayers();
            Intrinsics.checkNotNull((Object)set);
            set.remove(player);
        }
    }

    @Override
    public void update() {
        this.particleShape.accept(this.particleDisplay);
    }
}

