/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cooldown;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.kingdoms.utils.cooldown.CooldownContainer;

public class NestedCooldown {
    private final NestedCooldown parent;
    private final Map<Object, Object> cooldowns = new HashMap<Object, Object>();

    public NestedCooldown() {
        this.parent = null;
    }

    public NestedCooldown(NestedCooldown parent) {
        this.parent = parent;
    }

    public boolean add(long time, Object ... keys) {
        return this.add(time, TimeUnit.SECONDS, keys);
    }

    public boolean add(long time, TimeUnit timeUnit, Object ... keys) {
        if (this.isInCooldown(keys)) {
            return false;
        }
        int i = 0;
        NestedCooldown lastCooldown = this;
        for (Object key : keys) {
            if (++i == keys.length) {
                lastCooldown.cooldowns.put(key, new CooldownContainer(timeUnit.toMillis(time), System.currentTimeMillis()));
                return true;
            }
            NestedCooldown finalParent = lastCooldown;
            lastCooldown = (NestedCooldown)lastCooldown.cooldowns.computeIfAbsent(key, k -> new NestedCooldown(finalParent));
        }
        throw new AssertionError((Object)("Unable to initiate cooldown container with keys: " + Arrays.toString(keys)));
    }

    public boolean isInCooldown(Object ... keys) {
        return this.getTimeLeft(keys) != 0L;
    }

    public CooldownContainer stop(Object ... keys) {
        int i = 0;
        CooldownContainer removed = null;
        NestedCooldown lastCooldown = this;
        for (Object key : keys) {
            if (++i == keys.length) {
                removed = (CooldownContainer)this.cooldowns.remove(key);
                break;
            }
            lastCooldown = (NestedCooldown)lastCooldown.cooldowns.get(key);
            if (lastCooldown != null) continue;
            return null;
        }
        --i;
        while (i > 0) {
            if (lastCooldown.cooldowns.isEmpty()) {
                lastCooldown = lastCooldown.parent;
                if (lastCooldown == null) {
                    return removed;
                }
            } else {
                return removed;
            }
            lastCooldown.cooldowns.remove(keys[i]);
            --i;
        }
        throw new AssertionError((Object)("Unable to find cooldown container with keys: " + Arrays.toString(keys)));
    }

    public CooldownContainer get(Object ... keys) {
        int i = 0;
        NestedCooldown lastCooldown = this;
        for (Object key : keys) {
            if (++i == keys.length) {
                return (CooldownContainer)this.cooldowns.get(key);
            }
            lastCooldown = (NestedCooldown)lastCooldown.cooldowns.get(key);
        }
        throw new AssertionError((Object)("Unable to find cooldown container with keys: " + Arrays.toString(keys)));
    }

    public long getTimeLeft(Object ... keys) {
        CooldownContainer cooldown = this.get(keys);
        if (cooldown == null) {
            return 0L;
        }
        long now = System.currentTimeMillis();
        long difference = now - cooldown.start;
        if (difference >= cooldown.time) {
            this.stop(keys);
            return 0L;
        }
        return cooldown.time - difference;
    }
}

