/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config.importer;

import java.util.Map;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.common.NodeReplacer;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlImportDeclaration;
import org.kingdoms.utils.config.adapters.YamlModule;
import org.kingdoms.utils.config.importer.YamlDeclarationNotFoundException;
import org.kingdoms.utils.config.importer.YamlImportComposer;

public interface YamlImporter {
    public YamlModule getDeclaration(YamlImportDeclaration var1);

    public static void collectAnchors(YamlContainer container, Map<String, Anchor> anchors, YamlImporter importer, YamlImportDeclaration details) {
        String ns = details.getName();
        try {
            YamlModule module = importer.getDeclaration(details);
            if (module == null) {
                throw new YamlDeclarationNotFoundException(container, ns, importer);
            }
            for (YamlImportDeclaration subImport : module.getImports().values()) {
                YamlImporter.collectAnchors(container, anchors, importer, subImport);
            }
            for (String importedAnchor : details.getImportedAnchors()) {
                Anchor anchor = module.getAnchors().get(importedAnchor);
                if (anchor == null) {
                    throw new IllegalArgumentException("Unknown imported anchor " + importedAnchor + " for " + ns);
                }
                anchors.put(anchor.getIdentifier(), anchor);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while importing '" + ns + "' for " + container.getFile(), ex);
        }
    }

    public static void importTo(YamlContainer container, YamlImporter importer, YamlImportDeclaration details) {
        MappingNode root = container.getConfig().getNode();
        String ns = details.getName();
        try {
            YamlModule module = importer.getDeclaration(details);
            if (module == null) {
                throw new YamlDeclarationNotFoundException(container, ns, importer);
            }
            for (YamlImportDeclaration subImport : module.getImports().values()) {
                YamlImporter.importTo(container, importer, subImport);
            }
            if (details.getExtends()) {
                root.copyIfDoesntExist(module.getAdapter().getConfig().getNode(), module.getName(), "", a -> false);
            }
            if (details.getExtends()) {
                NodeReplacer replacer = new NodeReplacer(root, module.getParameterInputFrom(details), null).ignore(YamlImportComposer.INSTANCE);
                replacer.replaceAll();
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("Error while importing '" + ns + "' for " + container.getFile(), ex);
        }
    }
}

