/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config.importer;

import java.io.File;
import org.bukkit.plugin.Plugin;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.locale.SupportedLanguage;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.adapters.YamlImportDeclaration;
import org.kingdoms.utils.config.adapters.YamlModule;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.config.importer.YamlGlobalImporter;
import org.kingdoms.utils.config.importer.YamlImporter;
import org.kingdoms.utils.config.importer.YamlModuleLoader;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/kingdoms/utils/config/importer/YamlGUIImporter;", "Lorg/kingdoms/utils/config/importer/YamlImporter;", "lang", "Lorg/kingdoms/locale/SupportedLanguage;", "<init>", "(Lorg/kingdoms/locale/SupportedLanguage;)V", "getDeclaration", "Lorg/kingdoms/utils/config/adapters/YamlModule;", "details", "Lorg/kingdoms/utils/config/adapters/YamlImportDeclaration;", "core"})
public final class YamlGUIImporter
implements YamlImporter {
    @NotNull
    private final SupportedLanguage lang;

    public YamlGUIImporter(@NotNull SupportedLanguage lang) {
        Intrinsics.checkNotNullParameter((Object)lang, (String)"lang");
        this.lang = lang;
    }

    @Override
    @Nullable
    public YamlModule getDeclaration(@NotNull YamlImportDeclaration details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        String name = details.getName();
        String path = "guis/" + this.lang.getLowerCaseName() + "/templates/" + name + ".yml";
        String resourcePath = "guis/templates/" + name + ".yml";
        File localFile = new File(Kingdoms.get().getDataFolder(), path);
        YamlResource adapter = new YamlResource((Plugin)Kingdoms.get(), localFile, resourcePath).load();
        if (!adapter.defaultExists()) {
            File file = adapter.getFile();
            Intrinsics.checkNotNull((Object)file);
            if (!file.exists()) {
                return YamlGlobalImporter.INSTANCE.getDeclaration(details);
            }
        }
        String string = details.getName();
        Intrinsics.checkNotNull((Object)adapter);
        return new YamlModule(string, YamlModuleLoader.loadImports(adapter), adapter);
    }
}

