/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config.adapters;

import java.io.File;
import java.io.InputStream;
import org.bukkit.plugin.Plugin;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.adapters.YamlWithDefaults;
import org.kingdoms.utils.config.importer.YamlImporter;

public class YamlResource
extends YamlWithDefaults {
    protected final Plugin plugin;
    protected String resourcePath;

    public YamlResource(Plugin plugin, File file, String resourcePath) {
        super(file);
        this.resourcePath = resourcePath;
        this.plugin = plugin;
    }

    public YamlResource(File file, String resourcePath) {
        this((Plugin)Kingdoms.get(), file, resourcePath);
    }

    public YamlResource(File file) {
        this(file, file.getName());
    }

    @Override
    protected InputStream getDefaultsInputStream() {
        return this.resourcePath == null ? null : this.plugin.getResource(this.resourcePath);
    }

    @Override
    public YamlResource setImporter(YamlImporter importer) {
        super.setImporter(importer);
        return this;
    }

    @Override
    public YamlResource importDeclarations() {
        super.importDeclarations();
        return this;
    }

    @Override
    protected String getDefaultsPath() {
        return this.resourcePath;
    }

    @Override
    public YamlResource load() {
        super.load();
        return this;
    }

    @Override
    protected InputStream getSchemaInputStream() {
        return this.plugin.getResource("schemas/" + this.resourcePath);
    }

    public String toString() {
        return "YamlResource{plugin=" + this.plugin + ", resourcePath='" + this.resourcePath + '\'' + ", file=" + this.file + ", validator=" + (this.validator == null ? "NULL" : this.validator.getClass()) + ", importer=" + this.importer + ", loadAnchors=" + this.loadAnchors + '}';
    }
}

