/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config.adapters;

import java.io.InputStream;
import java.util.Objects;
import java.util.function.Function;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.snakeyaml.common.Anchor;

public final class YamlParseContext {
    private String name;
    private InputStream stream;
    @Nullable
    private Function<String, Anchor> anchorProcessor;
    private boolean resolveAliases = true;

    @NotNull
    public String getName() {
        return Objects.requireNonNull(this.name);
    }

    @NotNull
    public InputStream getStream() {
        return Objects.requireNonNull(this.stream);
    }

    @Nullable
    public Function<String, Anchor> getAnchorProcessor() {
        return this.anchorProcessor;
    }

    @NotNull
    public YamlParseContext named(@NotNull String name) {
        Objects.requireNonNull(name);
        this.name = name;
        return this;
    }

    @NotNull
    public YamlParseContext stream(@NotNull InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        this.stream = inputStream;
        return this;
    }

    @NotNull
    public YamlParseContext processAnchors(@NotNull Function<String, Anchor> anchorProcessor) {
        Objects.requireNonNull(anchorProcessor);
        this.anchorProcessor = anchorProcessor;
        return this;
    }

    public boolean shouldResolveAliases() {
        return this.resolveAliases;
    }

    @NotNull
    public YamlParseContext shouldResolveAliases(boolean resolveAliases) {
        this.resolveAliases = resolveAliases;
        return this;
    }
}

