/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config.adapters;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlImportDeclaration;
import org.kingdoms.utils.internal.nonnull.Nullability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001b0\u00052\u0006\u0010\u001c\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0014\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00160\u0015j\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0016`\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001e"}, d2={"Lorg/kingdoms/utils/config/adapters/YamlModule;", "", "name", "", "imports", "", "Lorg/kingdoms/utils/config/adapters/YamlImportDeclaration;", "adapter", "Lorg/kingdoms/utils/config/adapters/YamlContainer;", "<init>", "(Ljava/lang/String;Ljava/util/Map;Lorg/kingdoms/utils/config/adapters/YamlContainer;)V", "getName", "()Ljava/lang/String;", "getImports", "()Ljava/util/Map;", "getAdapter", "()Lorg/kingdoms/utils/config/adapters/YamlContainer;", "parameters", "", "Lorg/kingdoms/utils/config/adapters/YamlModule$Parameter;", "anchors", "Ljava/util/LinkedHashMap;", "Lorg/kingdoms/libs/snakeyaml/common/Anchor;", "Lorg/kingdoms/libs/kotlin/collections/LinkedHashMap;", "getAnchors", "()Ljava/util/LinkedHashMap;", "getParameterInputFrom", "Lorg/kingdoms/libs/snakeyaml/nodes/Node;", "section", "Parameter", "core"})
public final class YamlModule {
    @NotNull
    private final String name;
    @NotNull
    private final Map<String, YamlImportDeclaration> imports;
    @NotNull
    private final YamlContainer adapter;
    @NotNull
    private final Map<String, Parameter> parameters;
    @NotNull
    private final LinkedHashMap<String, Anchor> anchors;

    public YamlModule(@NotNull String name, @NotNull Map<String, YamlImportDeclaration> imports, @NotNull YamlContainer adapter) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(imports, (String)"imports");
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.name = name;
        this.imports = imports;
        this.adapter = adapter;
        this.parameters = new LinkedHashMap();
        ConfigSection configSection = this.adapter.getConfig();
        if (configSection == null) {
            throw new IllegalStateException("Config is null for " + this.name + " -> " + this.adapter);
        }
        ConfigSection config = configSection;
        this.anchors = config.getNode().getAnchors();
        String[] stringArray = new String[]{"(module)"};
        ConfigSection module = config.getSection(stringArray);
        if (module != null) {
            String[] stringArray2 = new String[]{"parameters"};
            ConfigSection parameters = module.getSection(stringArray2);
            if (parameters != null) {
                for (String paramName : parameters.getKeys()) {
                    String paramType = parameters.getString(paramName);
                    Node defaultValue = null;
                    if (paramType == null) {
                        String[] stringArray3 = new String[]{paramName};
                        ConfigSection param = parameters.getSection(stringArray3);
                        paramType = Nullability.assertNotNull(param.getString("type"), "No parameter type specified for " + paramName);
                        defaultValue = param.getNode("default");
                    }
                    Intrinsics.checkNotNull((Object)paramName);
                    this.parameters.put(paramName, new Parameter(paramName, paramType, defaultValue));
                }
            }
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Map<String, YamlImportDeclaration> getImports() {
        return this.imports;
    }

    @NotNull
    public final YamlContainer getAdapter() {
        return this.adapter;
    }

    @NotNull
    public final LinkedHashMap<String, Anchor> getAnchors() {
        return this.anchors;
    }

    @NotNull
    public final Map<String, Node> getParameterInputFrom(@NotNull YamlImportDeclaration section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        Map variables = new HashMap();
        String[] stringArray = new String[]{"parameters"};
        ConfigSection parameters = section.getInfo().getSection(stringArray);
        if (parameters != null) {
            for (String paramName : parameters.getKeys()) {
                Node node;
                Parameter parameterData = this.parameters.get(paramName);
                if (parameterData == null) {
                    throw new IllegalStateException("Unknown provided paramter named " + paramName + " for " + this.name + " YAML module");
                }
                Map map = variables;
                if (parameters.getNode(paramName) == null) {
                    throw new AssertionError((Object)("Missing parameter " + paramName + " for '" + this.name + "' YAML module"));
                }
                map.put(paramName, node);
            }
            for (Parameter param : this.parameters.values()) {
                if (variables.get(param.getName()) != null || param.getDefaultValue() == null) continue;
                variables.put(param.getName(), param.getDefaultValue());
            }
        }
        return variables;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/kingdoms/utils/config/adapters/YamlModule$Parameter;", "", "name", "", "type", "defaultValue", "Lorg/kingdoms/libs/snakeyaml/nodes/Node;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/snakeyaml/nodes/Node;)V", "getName", "()Ljava/lang/String;", "getType", "getDefaultValue", "()Lorg/snakeyaml/nodes/Node;", "core"})
    public static final class Parameter {
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        @Nullable
        private final Node defaultValue;

        public Parameter(@NotNull String name, @NotNull String type, @Nullable Node defaultValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name;
            this.type = type;
            this.defaultValue = defaultValue;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final Node getDefaultValue() {
            return this.defaultValue;
        }
    }
}

