/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config.adapters;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.snakeyaml.api.Load;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.common.Anchor;
import org.kingdoms.libs.snakeyaml.common.Composer;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.validation.NodeValidator;
import org.kingdoms.libs.snakeyaml.validation.Validator;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.adapters.YamlImportDeclaration;
import org.kingdoms.utils.config.adapters.YamlModule;
import org.kingdoms.utils.config.adapters.YamlParseContext;
import org.kingdoms.utils.config.importer.YamlDeclarationNotFoundException;
import org.kingdoms.utils.config.importer.YamlImporter;
import org.kingdoms.utils.config.importer.YamlModuleLoader;

public interface YamlContainer {
    public ConfigSection getConfig();

    public ConfigAccessor accessor();

    public void saveConfig();

    public YamlContainer setResolveAliases(boolean var1);

    default public boolean isLoaded() {
        return this.getConfig() != null;
    }

    @Nullable
    public File getFile();

    default public void createFile() {
        try {
            this.getFile().createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public YamlContainer setImporter(YamlImporter var1);

    public YamlImporter getImporter();

    @NotNull
    default public YamlContainer importDeclarations() {
        Collection<YamlImportDeclaration> imports;
        YamlImporter importer = this.getImporter();
        if (importer == null) {
            return this;
        }
        if (this.getConfig() == null) {
            return this;
        }
        LoadSettings settings = new LoadSettings();
        settings.setLabel("Importer");
        Load load = new Load(settings);
        MappingNode root = this.getConfig().getNode();
        try {
            imports = YamlModuleLoader.loadImports(this).values();
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while loading imports for " + this, ex);
        }
        LinkedHashMap<String, Anchor> anchors = new LinkedHashMap<String, Anchor>();
        for (YamlImportDeclaration importDeclr : imports) {
            YamlModule module = importer.getDeclaration(importDeclr);
            if (module == null) {
                throw new YamlDeclarationNotFoundException(this, importDeclr.getName(), importer);
            }
            YamlImporter.collectAnchors(this, anchors, importer, importDeclr);
        }
        Composer.collectAnchors(root, anchors);
        Composer.resolveAliases(root, settings, anchors);
        load.construct(root);
        for (YamlImportDeclaration importDeclr : imports) {
            YamlModule module = importer.getDeclaration(importDeclr);
            if (module == null) {
                throw new YamlDeclarationNotFoundException(this, importDeclr.getName(), importer);
            }
            YamlImporter.importTo(this, importer, importDeclr);
        }
        return this;
    }

    @NotNull
    public static MappingNode parse(YamlParseContext context) {
        LoadSettings settings = new LoadSettings();
        settings.setLabel(context.getName());
        settings.setResolveAliases(context.shouldResolveAliases());
        Load load = new Load(settings);
        Composer composer = load.createComposer(context.getStream());
        MappingNode root = composer.getRoot();
        load.construct(root);
        return root;
    }

    public static NodeValidator parseValidator(String label, String resourcePath) {
        InputStream is = Kingdoms.get().getResource(resourcePath);
        return YamlContainer.parseValidator(is, label);
    }

    public static NodeValidator parseValidator(InputStream is, String label) {
        LoadSettings settings = new LoadSettings();
        settings.setLabel(label + " Schema");
        Load load = new Load(settings);
        Composer composer = load.createComposer(is);
        MappingNode schemaYml = composer.getRoot();
        load.construct(schemaYml);
        return Validator.parseSchema(schemaYml);
    }

    public YamlContainer load();

    public void reload();
}

