/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.snakeyaml.api.LoadSettings;
import org.kingdoms.libs.snakeyaml.common.FlowStyle;
import org.kingdoms.libs.snakeyaml.common.ScalarStyle;
import org.kingdoms.libs.snakeyaml.constructor.BaseConstructor;
import org.kingdoms.libs.snakeyaml.constructor.StandardConstructor;
import org.kingdoms.libs.snakeyaml.nodes.MappingNode;
import org.kingdoms.libs.snakeyaml.nodes.Node;
import org.kingdoms.libs.snakeyaml.nodes.NodeType;
import org.kingdoms.libs.snakeyaml.nodes.ScalarNode;
import org.kingdoms.libs.snakeyaml.nodes.SequenceNode;
import org.kingdoms.libs.snakeyaml.nodes.Tag;
import org.kingdoms.libs.snakeyaml.resolver.StandardScalarResolver;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.LanguageEntry;
import org.kingdoms.locale.placeholders.context.PlaceholderProvider;
import org.kingdoms.utils.MathUtils;
import org.kingdoms.utils.compilers.ConditionalCompiler;
import org.kingdoms.utils.compilers.MathCompiler;
import org.kingdoms.utils.compilers.expressions.ConditionalExpression;
import org.kingdoms.utils.compilers.expressions.MathExpression;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.CustomConfigValidators;
import org.kingdoms.utils.config.NodeInterpretContext;
import org.kingdoms.utils.string.Strings;
import org.kingdoms.utils.time.TimeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00e6\u0080\u0001\u0018\u0000 \t*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\tJ\u001b\u0010\u0003\u001a\u00028\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H&\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\u0003\u001a\u00028\u00002\b\u0010\u0004\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lorg/kingdoms/utils/config/NodeInterpreter;", "T", "", "parse", "node", "Lorg/kingdoms/utils/config/NodeInterpretContext;", "(Lorg/kingdoms/utils/config/NodeInterpretContext;)Ljava/lang/Object;", "Lorg/kingdoms/libs/snakeyaml/nodes/Node;", "(Lorg/snakeyaml/nodes/Node;)Ljava/lang/Object;", "Companion", "core"})
public interface NodeInterpreter<T> {
    @NotNull
    public static final Companion Companion = org.kingdoms.utils.config.NodeInterpreter$Companion.$$INSTANCE;
    @JvmField
    @NotNull
    public static final BaseConstructor DEFAULT_CTOR = new StandardConstructor(new LoadSettings());
    @JvmField
    @NotNull
    public static final StandardScalarResolver DEFAULT_RESOLVER = new StandardScalarResolver();
    @JvmField
    @NotNull
    public static final NodeInterpreter<String> STRING = NodeInterpreter::STRING$lambda$0;
    @JvmField
    @NotNull
    public static final NodeInterpreter<List<Integer>> INT_LIST = NodeInterpreter::INT_LIST$lambda$1;
    @JvmField
    @NotNull
    public static final NodeInterpreter<List<String>> STRING_LIST = NodeInterpreter::STRING_LIST$lambda$2;
    @JvmField
    @NotNull
    public static final NodeInterpreter<List<ConfigSection>> SECTION_LIST = NodeInterpreter::SECTION_LIST$lambda$3;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Float> FLOAT = NodeInterpreter::FLOAT$lambda$4;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Long> LONG = NodeInterpreter::LONG$lambda$5;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Double> DOUBLE = NodeInterpreter::DOUBLE$lambda$6;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Boolean> BOOLEAN = NodeInterpreter::BOOLEAN$lambda$7;
    @JvmField
    @NotNull
    public static final NodeInterpreter<Integer> INT = NodeInterpreter::INT$lambda$8;
    @JvmField
    @NotNull
    public static final NodeInterpreter<ConditionalExpression> CONDITION = NodeInterpreter::CONDITION$lambda$9;
    @JvmField
    @NotNull
    public static final NodeInterpreter<MathExpression> MATH = NodeInterpreter::MATH$lambda$10;
    @JvmField
    @NotNull
    public static final NodeInterpreter<LanguageEntry> LANGUAGE_ENTRY = NodeInterpreter::LANGUAGE_ENTRY$lambda$11;

    public T parse(@NotNull NodeInterpretContext<T> var1);

    default public T parse(@Nullable Node node) {
        return (T)this.parse(new NodeInterpretContext(node));
    }

    private static String STRING$lambda$0(NodeInterpretContext it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return (String)NodeInterpretContext.asResult$default(it, NodeInterpretContext.Result.NULL, null, 2, null);
        }
        Node node2 = node;
        if (node2.getNodeType() != NodeType.SCALAR) {
            return (String)NodeInterpretContext.asResult$default(it, NodeInterpretContext.Result.DIFFERENT_TYPE, null, 2, null);
        }
        if (node2.getParsed() == null) {
            string = null;
        } else {
            Node node3 = it.getNode();
            Intrinsics.checkNotNull((Object)node3, (String)"null cannot be cast to non-null type org.snakeyaml.nodes.ScalarNode");
            string = ((ScalarNode)node3).getValue();
        }
        return string;
    }

    private static List INT_LIST$lambda$1(NodeInterpretContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, new ArrayList());
        }
        Node node2 = node;
        if (node2.getNodeType() != NodeType.SEQUENCE) {
            return it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, new ArrayList());
        }
        SequenceNode seq = (SequenceNode)node2;
        List list = new ArrayList(seq.getValue().size());
        for (Node item : seq.getValue()) {
            if (!(item.getParsed() instanceof Number)) continue;
            Object object = item.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            list.add(((Number)object).intValue());
        }
        return list;
    }

    private static List STRING_LIST$lambda$2(NodeInterpretContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, new ArrayList());
        }
        Node node2 = node;
        if (node2.getNodeType() != NodeType.SEQUENCE) {
            if (node2.getNodeType() == NodeType.SCALAR) {
                ScalarNode scalarNode = (ScalarNode)node2;
                return Strings.split(scalarNode.getValue(), '\n', true);
            }
            return it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, new ArrayList());
        }
        SequenceNode sequenceNode = (SequenceNode)node2;
        List strings = new ArrayList(sequenceNode.getValue().size());
        for (Node element : sequenceNode.getValue()) {
            String parsed = STRING.parse(new NodeInterpretContext(element));
            if (parsed == null) continue;
            strings.add(parsed);
        }
        return strings;
    }

    private static List SECTION_LIST$lambda$3(NodeInterpretContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, new ArrayList());
        }
        Node node2 = node;
        if (node2.getNodeType() != NodeType.SEQUENCE) {
            return it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, new ArrayList());
        }
        SequenceNode sequenceNode = (SequenceNode)node2;
        List elements = new ArrayList(sequenceNode.getValue().size());
        for (Node element : sequenceNode.getValue()) {
            if (!(element instanceof MappingNode)) continue;
            elements.add(new ConfigSection((MappingNode)element));
        }
        return elements;
    }

    private static Float FLOAT$lambda$4(NodeInterpretContext it) {
        Float f;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, Float.valueOf(0.0f));
        }
        Node node2 = node;
        if (!(node2.getParsed() instanceof Number)) {
            f = it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, Float.valueOf(0.0f));
        } else {
            Object object = node2.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            f = Float.valueOf(((Number)object).floatValue());
        }
        return f;
    }

    private static Long LONG$lambda$5(NodeInterpretContext it) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, 0L);
        }
        Node node2 = node;
        if (!(node2.getParsed() instanceof Number)) {
            l = it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, 0L);
        } else {
            Object object = node2.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            l = ((Number)object).longValue();
        }
        return l;
    }

    private static Double DOUBLE$lambda$6(NodeInterpretContext it) {
        Double d;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, 0.0);
        }
        Node node2 = node;
        if (!(node2.getParsed() instanceof Number)) {
            d = it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, 0.0);
        } else {
            Object object = node2.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            d = ((Number)object).doubleValue();
        }
        return d;
    }

    private static Boolean BOOLEAN$lambda$7(NodeInterpretContext it) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, false);
        }
        Node node2 = node;
        if (!(node2.getParsed() instanceof Boolean)) {
            bl = it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, false);
        } else {
            Object object = node2.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            bl = (Boolean)object;
        }
        return bl;
    }

    private static Integer INT$lambda$8(NodeInterpretContext it) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, 0);
        }
        Node node2 = node;
        if (!(node2.getParsed() instanceof Number)) {
            n = it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, 0);
        } else {
            Object object = node2.getParsed();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Number");
            n = ((Number)object).intValue();
        }
        return n;
    }

    private static ConditionalExpression CONDITION$lambda$9(NodeInterpretContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return (ConditionalExpression)NodeInterpretContext.asResult$default(it, NodeInterpretContext.Result.NULL, null, 2, null);
        }
        Node node2 = node;
        if (node2.getNodeType() != NodeType.SCALAR) {
            return (ConditionalExpression)NodeInterpretContext.asResult$default(it, NodeInterpretContext.Result.DIFFERENT_TYPE, null, 2, null);
        }
        if (!(node2.getParsed() instanceof ConditionalExpression)) {
            ScalarNode scalarNode = (ScalarNode)node2;
            ((ScalarNode)node2).cacheConstructed(ConditionalCompiler.compile(scalarNode.getValue()).evaluate());
        }
        Object object = node2.getParsed();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.expressions.ConditionalExpression");
        return (ConditionalExpression)object;
    }

    private static MathExpression MATH$lambda$10(NodeInterpretContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, MathCompiler.DEFAULT_VALUE);
        }
        Node node2 = node;
        if (node2.getNodeType() != NodeType.SCALAR) {
            return it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, MathCompiler.DEFAULT_VALUE);
        }
        if (!(node2.getParsed() instanceof MathExpression)) {
            ScalarNode scalarNode = (ScalarNode)node2;
            Long time = TimeUtils.parseTime(scalarNode.getValue());
            if (time != null) {
                ((ScalarNode)node2).cacheConstructed(new MathCompiler.ConstantExpr(time.longValue(), MathCompiler.ConstantExprType.TIME));
            } else {
                ((ScalarNode)node2).cacheConstructed(MathCompiler.Companion.compile(scalarNode.getValue()));
            }
        }
        Object object = node2.getParsed();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.utils.compilers.expressions.MathExpression");
        return (MathExpression)object;
    }

    private static LanguageEntry LANGUAGE_ENTRY$lambda$11(NodeInterpretContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Node node = it.getNode();
        if (node == null) {
            return it.asResult(NodeInterpretContext.Result.NULL, KingdomsLang.UNKNOWN_MESSAGE_ENTRY.getLanguageEntry());
        }
        Node node2 = node;
        if (node2.getNodeType() != NodeType.SCALAR) {
            return it.asResult(NodeInterpretContext.Result.DIFFERENT_TYPE, KingdomsLang.UNKNOWN_MESSAGE_ENTRY.getLanguageEntry());
        }
        if (!(node2.getParsed() instanceof LanguageEntry)) {
            ScalarNode scalarNode = (ScalarNode)node2;
            ((ScalarNode)node2).cacheConstructed(LanguageEntry.fromString(scalarNode.getValue()));
        }
        Object object = node2.getParsed();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.kingdoms.locale.LanguageEntry");
        return (LanguageEntry)object;
    }

    @JvmStatic
    @Nullable
    public static Duration getTime(@Nullable Node node, @Nullable PlaceholderProvider ctx) {
        return Companion.getTime(node, ctx);
    }

    @JvmStatic
    @NotNull
    public static Node nodeOfObject(@Nullable Object obj) {
        return Companion.nodeOfObject(obj);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0007R\u0013\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u0013\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R!\u0010\u0013\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u00140\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R!\u0010\u0016\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00140\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R!\u0010\u0017\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u00140\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001R\u001b\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010'0\u00118\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u00a8\u0006("}, d2={"Lorg/kingdoms/utils/config/NodeInterpreter$Companion;", "", "<init>", "()V", "DEFAULT_CTOR", "Lorg/kingdoms/libs/snakeyaml/constructor/BaseConstructor;", "DEFAULT_RESOLVER", "Lorg/kingdoms/libs/snakeyaml/resolver/StandardScalarResolver;", "getTime", "Ljava/time/Duration;", "node", "Lorg/kingdoms/libs/snakeyaml/nodes/Node;", "ctx", "Lorg/kingdoms/locale/placeholders/context/PlaceholderProvider;", "nodeOfObject", "obj", "STRING", "Lorg/kingdoms/utils/config/NodeInterpreter;", "", "INT_LIST", "", "", "STRING_LIST", "SECTION_LIST", "Lorg/kingdoms/utils/config/ConfigSection;", "FLOAT", "", "LONG", "", "DOUBLE", "", "BOOLEAN", "", "INT", "CONDITION", "Lorg/kingdoms/utils/compilers/expressions/ConditionalExpression;", "MATH", "Lorg/kingdoms/utils/compilers/expressions/MathExpression;", "LANGUAGE_ENTRY", "Lorg/kingdoms/locale/LanguageEntry;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final Duration getTime(@Nullable Node node, @Nullable PlaceholderProvider ctx) {
            if (node == null) {
                return null;
            }
            Object cache = null;
            if (node.getTag() != CustomConfigValidators.PERIOD) {
                Object object;
                ScalarNode scalarNode = (ScalarNode)node;
                try {
                    object = MathCompiler.Companion.compile(scalarNode.getValue());
                }
                catch (Throwable ignored) {
                    Long l = TimeUtils.parseTime(scalarNode.getValue());
                    if (l == null) {
                        return null;
                    }
                    object = Duration.ofMillis(l);
                }
                cache = object;
                if (cache == null) {
                    return null;
                }
                ((ScalarNode)node).setTag(CustomConfigValidators.PERIOD);
                ((ScalarNode)node).cacheConstructed(cache);
            } else {
                cache = node.getParsed();
            }
            Object object = cache;
            return object instanceof Number ? Duration.ofMillis(((Number)cache).longValue()) : (object instanceof Duration ? (Duration)cache : Duration.ofMillis((long)MathUtils.eval((MathExpression)cache, ctx)));
        }

        @JvmStatic
        @NotNull
        public final Node nodeOfObject(@Nullable Object obj) {
            if (obj == null) {
                return new ScalarNode(Tag.NULL, "~", ScalarStyle.PLAIN);
            }
            if (obj instanceof Node) {
                return (Node)obj;
            }
            if (obj instanceof ConfigSection) {
                MappingNode mappingNode = ((ConfigSection)obj).getNode();
                Intrinsics.checkNotNullExpressionValue((Object)mappingNode, (String)"getNode(...)");
                return mappingNode;
            }
            if (obj instanceof Collection) {
                List nodes = new ArrayList(((Collection)obj).size());
                for (Object item : (Collection)obj) {
                    nodes.add(this.nodeOfObject(item));
                }
                return new SequenceNode(Tag.SEQ, nodes, FlowStyle.AUTO);
            }
            if (obj instanceof Map) {
                throw new UnsupportedOperationException("Mapping from objects");
            }
            ScalarNode node = new ScalarNode(DEFAULT_RESOLVER.resolve(obj.toString()), obj.toString(), ScalarStyle.AUTO);
            node.cacheConstructed(DEFAULT_CTOR.constructObject(node));
            return node;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

