/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.config;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kingdoms.data.Pair;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.config.adapters.YamlContainer;
import org.kingdoms.utils.config.adapters.YamlFile;
import org.kingdoms.utils.config.adapters.YamlResource;
import org.kingdoms.utils.fs.FolderRegistry;

public final class FolderYamlRegistry
extends FolderRegistry {
    private final String folderName;
    private final BiConsumer<String, YamlContainer> registrar;
    private final Map<String, YamlContainer> defaults = new HashMap<String, YamlContainer>();
    private final Map<String, YamlContainer> registered = new HashMap<String, YamlContainer>();

    public FolderYamlRegistry(String displayName, String folderName, BiConsumer<String, YamlContainer> registrar) {
        super(displayName, Kingdoms.getPath(folderName));
        this.registrar = registrar;
        this.folderName = folderName;
    }

    @Override
    protected Pair<String, URI> getDefaultsURI() {
        URI uri;
        try {
            uri = Kingdoms.class.getResource('/' + this.folderName).toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return Pair.of(this.folderName, uri);
    }

    @Override
    protected void handle(FolderRegistry.Entry entry) {
        String pathLocation = this.folderName + '/' + entry.getRelativeName().replace('\\', '/');
        String name = entry.getName();
        if (entry.isDefault()) {
            YamlContainer adapter = this.createYAML(new File(Kingdoms.get().getDataFolder(), pathLocation), pathLocation);
            this.registered.put(name, adapter);
            this.defaults.put(name, adapter);
        } else {
            YamlContainer adapter = this.createYAML(entry.getPath().toFile(), pathLocation);
            this.registered.put(name, adapter);
            this.registrar.accept(name, adapter);
        }
    }

    private YamlContainer createYAML(File file, String resourcePath) {
        if (this.useDefaults) {
            return new YamlResource(file, resourcePath);
        }
        return new YamlFile(file);
    }

    private void registerDefaults(boolean registerAll) {
        this.visitDefaults();
        for (Map.Entry<String, YamlContainer> defaultYaml : this.defaults.entrySet()) {
            try {
                String name = defaultYaml.getKey();
                if (!registerAll && this.registered.containsKey(name)) continue;
                this.registered.put(name, defaultYaml.getValue());
                this.registrar.accept(name, defaultYaml.getValue());
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Error while registering default " + this.displayName + " '" + defaultYaml.getKey() + "' " + defaultYaml.getValue().getFile(), ex);
            }
        }
    }

    @Override
    public void register() {
        if (!Files.exists(this.folder, new LinkOption[0])) {
            this.registerDefaults(true);
        } else {
            this.visitPresent();
            if (this.useDefaults) {
                this.registerDefaults(false);
            }
        }
    }
}

