/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageCompilerSettings;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.utils.string.Strings;

public final class ConfigCommand {
    private final ExecutorType executorType;
    private final MessageObject command;
    private static final MessageCompilerSettings COMPILER_SETTINGS = MessageCompilerSettings.none().colorize().translatePlaceholders();

    public ConfigCommand(ExecutorType executorType, MessageObject command) {
        this.executorType = executorType;
        this.command = command;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<ConfigCommand> parse(Collection<String> commands) {
        if (commands == null) {
            return Collections.emptyList();
        }
        ArrayList<ConfigCommand> list = new ArrayList<ConfigCommand>(commands.size());
        for (String command : commands) {
            ExecutorType executorType;
            int index = command.indexOf(58);
            if (index != -1) {
                String option = Strings.toLatinUpperCase(command.substring(0, index));
                command = command.substring(index + 1);
                if (option.equals("CONSOLE")) {
                    executorType = ExecutorType.CONSOLE;
                } else {
                    if (!option.equals("OP")) throw new IllegalArgumentException("Unknown command executor '" + option + "' in command: " + command);
                    executorType = ExecutorType.OP;
                }
            } else {
                executorType = ExecutorType.NORMAL;
            }
            if (command.charAt(0) == '/') {
                command = command.substring(1);
            }
            list.add(new ConfigCommand(executorType, MessageCompiler.compile(command, COMPILER_SETTINGS)));
        }
        return list;
    }

    public static void execute(@Nullable Player player, Collection<ConfigCommand> commands, MessagePlaceholderProvider settings, boolean ignoreIfPlayerNull) {
        if (Bukkit.isPrimaryThread()) {
            ConfigCommand.execute0(player, commands, settings, ignoreIfPlayerNull);
        } else {
            Bukkit.getScheduler().runTask((Plugin)Kingdoms.get(), () -> ConfigCommand.execute0(player, commands, settings, ignoreIfPlayerNull));
        }
    }

    private static void execute0(@Nullable Player player, Collection<ConfigCommand> commands, MessagePlaceholderProvider settings, boolean ignoreIfPlayerNull) {
        Consumer<ConfigCommand> checkPlayer = cmd -> Objects.requireNonNull(player, () -> "An online player must be present to execute the command '" + cmd.command.buildPlain(settings) + "' of type " + (Object)((Object)cmd.executorType));
        block5: for (ConfigCommand command : commands) {
            String parsedCmd = command.command.buildPlain(settings);
            switch (command.executorType.ordinal()) {
                case 0: {
                    boolean wasNotOp;
                    if (ignoreIfPlayerNull && player == null) continue block5;
                    checkPlayer.accept(command);
                    boolean bl = wasNotOp = !player.isOp();
                    if (wasNotOp) {
                        player.setOp(true);
                    }
                    Bukkit.dispatchCommand((CommandSender)player, (String)parsedCmd);
                    if (!wasNotOp) continue block5;
                    player.setOp(false);
                    continue block5;
                }
                case 1: {
                    Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)parsedCmd);
                    continue block5;
                }
                case 2: {
                    if (ignoreIfPlayerNull && player == null) continue block5;
                    checkPlayer.accept(command);
                    Bukkit.dispatchCommand((CommandSender)player, (String)parsedCmd);
                    continue block5;
                }
            }
            throw new AssertionError();
        }
    }

    public String toString() {
        return "ConfigCommand{executorType=" + (Object)((Object)this.executorType) + ", command=" + this.command + '}';
    }

    public static enum ExecutorType {
        OP,
        CONSOLE,
        NORMAL;

    }
}

