/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.chunks;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.enums.EnumEntries;
import org.kingdoms.libs.kotlin.enums.EnumEntriesKt;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.server.location.Direction;
import org.kingdoms.utils.MathUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u001c\u001a\u00020\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006 "}, d2={"Lorg/kingdoms/utils/chunks/ChunkLocationMapper;", "", "chunks", "", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "useNegativeSpace", "", "insideRadiusShrink", "", "insideLocationsChance", "", "<init>", "(Ljava/util/Set;ZID)V", "getChunks", "()Ljava/util/Set;", "getUseNegativeSpace", "()Z", "getInsideRadiusShrink", "()I", "getInsideLocationsChance", "()D", "insideLocations", "", "Lorg/bukkit/Location;", "getInsideLocations", "()Ljava/util/List;", "borderLocations", "getBorderLocations", "populateLocations", "Companion", "ChunkBorder", "ChunkMapper", "core"})
@SourceDebugExtension(value={"SMAP\nChunkLocationMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkLocationMapper.kt\norg/kingdoms/utils/chunks/ChunkLocationMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
public final class ChunkLocationMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<SimpleChunkLocation> chunks;
    private final boolean useNegativeSpace;
    private final int insideRadiusShrink;
    private final double insideLocationsChance;
    @NotNull
    private final List<Location> insideLocations;
    @NotNull
    private final List<Location> borderLocations;
    private static final int CHUNK_SIDES_BLOCKS = 16;

    public ChunkLocationMapper(@NotNull Set<? extends SimpleChunkLocation> chunks, boolean useNegativeSpace, int insideRadiusShrink, double insideLocationsChance) {
        Intrinsics.checkNotNullParameter(chunks, (String)"chunks");
        this.chunks = chunks;
        this.useNegativeSpace = useNegativeSpace;
        this.insideRadiusShrink = insideRadiusShrink;
        this.insideLocationsChance = insideLocationsChance;
        this.insideLocations = new ArrayList(this.chunks.size() * CHUNK_SIDES_BLOCKS * CHUNK_SIDES_BLOCKS);
        this.borderLocations = new ArrayList((int)Math.ceil((double)this.chunks.size() / 2.0) * CHUNK_SIDES_BLOCKS * 4);
        double d = this.insideLocationsChance;
        if (!(0.0 <= d ? d <= 100.0 : false)) {
            boolean bl = false;
            String string = "insideLocationsChance must be between 0 - 100";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final Set<SimpleChunkLocation> getChunks() {
        return this.chunks;
    }

    public final boolean getUseNegativeSpace() {
        return this.useNegativeSpace;
    }

    public final int getInsideRadiusShrink() {
        return this.insideRadiusShrink;
    }

    public final double getInsideLocationsChance() {
        return this.insideLocationsChance;
    }

    @NotNull
    public final List<Location> getInsideLocations() {
        return this.insideLocations;
    }

    @NotNull
    public final List<Location> getBorderLocations() {
        return this.borderLocations;
    }

    @NotNull
    public final ChunkLocationMapper populateLocations() {
        for (SimpleChunkLocation chunk : this.chunks) {
            ChunkMapper mapper = new ChunkMapper(chunk);
            mapper.populateInner();
            for (ChunkBorder border : ChunkBorder.VALUES) {
                SimpleChunkLocation relative;
                if (this.useNegativeSpace && this.chunks.contains(relative = border.getRelativeChunk(chunk))) continue;
                border.populate(mapper);
            }
        }
        return this;
    }

    public static final int getCHUNK_SIDES_BLOCKS() {
        return Companion.getCHUNK_SIDES_BLOCKS();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0081\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0012R\u00020\u0013H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\u0015"}, d2={"Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkBorder;", "", "direction", "Lorg/kingdoms/server/location/Direction;", "<init>", "(Ljava/lang/String;ILorg/kingdoms/server/location/Direction;)V", "getDirection", "()Lorg/kingdoms/server/location/Direction;", "NORTH", "SOUTH", "WEST", "EAST", "getRelativeChunk", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "chunk", "populate", "", "mapper", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkMapper;", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper;", "Companion", "core"})
    public static final abstract class ChunkBorder
    extends Enum<ChunkBorder> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Direction direction;
        @JvmField
        @NotNull
        public static final ChunkBorder[] VALUES;
        public static final /* enum */ ChunkBorder NORTH;
        public static final /* enum */ ChunkBorder SOUTH;
        public static final /* enum */ ChunkBorder WEST;
        public static final /* enum */ ChunkBorder EAST;
        private static final /* synthetic */ ChunkBorder[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ChunkBorder(Direction direction) {
            this.direction = direction;
        }

        @NotNull
        public final Direction getDirection() {
            return this.direction;
        }

        @NotNull
        public final SimpleChunkLocation getRelativeChunk(@NotNull SimpleChunkLocation chunk) {
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            SimpleChunkLocation simpleChunkLocation = chunk.getRelative(this.direction);
            Intrinsics.checkNotNullExpressionValue((Object)simpleChunkLocation, (String)"getRelative(...)");
            return simpleChunkLocation;
        }

        public abstract void populate(@NotNull ChunkMapper var1);

        public static ChunkBorder[] values() {
            return (ChunkBorder[])$VALUES.clone();
        }

        public static ChunkBorder valueOf(String value) {
            return Enum.valueOf(ChunkBorder.class, value);
        }

        @NotNull
        public static EnumEntries<ChunkBorder> getEntries() {
            return $ENTRIES;
        }

        public /* synthetic */ ChunkBorder(String $enum$name, int $enum$ordinal, Direction direction, DefaultConstructorMarker $constructor_marker) {
            this(direction);
        }

        static {
            NORTH = new NORTH("NORTH", 0);
            SOUTH = new SOUTH("SOUTH", 1);
            WEST = new WEST("WEST", 2);
            EAST = new EAST("EAST", 3);
            $VALUES = chunkBorderArray = new ChunkBorder[]{ChunkBorder.NORTH, ChunkBorder.SOUTH, ChunkBorder.WEST, ChunkBorder.EAST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
            VALUES = ChunkBorder.values();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\b\u0012\u0004\b\u0007\u0010\u0003\u00a8\u0006\t"}, d2={"Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkBorder$Companion;", "", "<init>", "()V", "VALUES", "", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkBorder;", "getVALUES$annotations", "[Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkBorder;", "core"})
        public static final class Companion {
            private Companion() {
            }

            public static /* synthetic */ void getVALUES$annotations() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"org/kingdoms/utils/chunks/ChunkLocationMapper.ChunkBorder.EAST", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkBorder;", "populate", "", "mapper", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkMapper;", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper;", "core"})
        static final class EAST
        extends ChunkBorder {
            /*
             * WARNING - void declaration
             */
            EAST() {
                void var1_1;
            }

            @Override
            public void populate(@NotNull ChunkMapper mapper) {
                Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
                mapper.populateBorder(false, ChunkLocationMapper.Companion.getCHUNK_SIDES_BLOCKS(), 0);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"org/kingdoms/utils/chunks/ChunkLocationMapper.ChunkBorder.NORTH", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkBorder;", "populate", "", "mapper", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkMapper;", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper;", "core"})
        static final class NORTH
        extends ChunkBorder {
            /*
             * WARNING - void declaration
             */
            NORTH() {
                void var1_1;
            }

            @Override
            public void populate(@NotNull ChunkMapper mapper) {
                Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
                mapper.populateBorder(true, 0, 0);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"org/kingdoms/utils/chunks/ChunkLocationMapper.ChunkBorder.SOUTH", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkBorder;", "populate", "", "mapper", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkMapper;", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper;", "core"})
        static final class SOUTH
        extends ChunkBorder {
            /*
             * WARNING - void declaration
             */
            SOUTH() {
                void var1_1;
            }

            @Override
            public void populate(@NotNull ChunkMapper mapper) {
                Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
                mapper.populateBorder(true, 0, ChunkLocationMapper.Companion.getCHUNK_SIDES_BLOCKS());
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\u00ca\u0001\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"org/kingdoms/utils/chunks/ChunkLocationMapper.ChunkBorder.WEST", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkBorder;", "populate", "", "mapper", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkMapper;", "Lorg/kingdoms/utils/chunks/ChunkLocationMapper;", "core"})
        static final class WEST
        extends ChunkBorder {
            /*
             * WARNING - void declaration
             */
            WEST() {
                void var1_1;
            }

            @Override
            public void populate(@NotNull ChunkMapper mapper) {
                Intrinsics.checkNotNullParameter((Object)mapper, (String)"mapper");
                mapper.populateBorder(false, 0, 0);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\rR\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/kingdoms/utils/chunks/ChunkLocationMapper$ChunkMapper;", "", "chunk", "Lorg/kingdoms/constants/land/location/SimpleChunkLocation;", "<init>", "(Lorg/kingdoms/utils/chunks/ChunkLocationMapper;Lorg/kingdoms/constants/land/location/SimpleChunkLocation;)V", "world", "Lorg/bukkit/World;", "Lorg/kingdoms/libs/checkerframework/checker/nullness/qual/NonNull;", "offsetX", "", "offsetZ", "populateBorder", "", "iteratingX", "", "xRow", "zRow", "populateInner", "core"})
    public final class ChunkMapper {
        @NotNull
        private final World world;
        private final int offsetX;
        private final int offsetZ;

        public ChunkMapper(SimpleChunkLocation chunk) {
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            World world = chunk.getBukkitWorld();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getBukkitWorld(...)");
            this.world = world;
            this.offsetX = chunk.getX() * Companion.getCHUNK_SIDES_BLOCKS();
            this.offsetZ = chunk.getZ() * Companion.getCHUNK_SIDES_BLOCKS();
        }

        public final void populateBorder(boolean iteratingX, int xRow, int zRow) {
            int i = 0;
            int n = Companion.getCHUNK_SIDES_BLOCKS();
            if (i <= n) {
                while (true) {
                    Block block;
                    int blocklocX = this.offsetX + xRow + (iteratingX ? i : 0);
                    int blocklocZ = this.offsetZ + zRow + (iteratingX ? 0 : i);
                    Intrinsics.checkNotNullExpressionValue((Object)this.world.getHighestBlockAt(blocklocX, blocklocZ), (String)"getHighestBlockAt(...)");
                    ChunkLocationMapper.this.getBorderLocations().add(new Location(this.world, (double)block.getX(), (double)(block.getY() + 1), (double)block.getZ()));
                    if (i == n) break;
                    ++i;
                }
            }
        }

        public final void populateInner() {
            int end;
            if (ChunkLocationMapper.this.getInsideLocationsChance() == 0.0) {
                return;
            }
            int begin = 1 + ChunkLocationMapper.this.getInsideRadiusShrink();
            int x = begin;
            if (x <= (end = Companion.getCHUNK_SIDES_BLOCKS() - 1 - ChunkLocationMapper.this.getInsideRadiusShrink())) {
                while (true) {
                    int z;
                    if ((z = begin) <= end) {
                        while (true) {
                            if (!(ChunkLocationMapper.this.getInsideLocationsChance() < 100.0) || !MathUtils.hasChance((double)100 - ChunkLocationMapper.this.getInsideLocationsChance())) {
                                Block block;
                                int blocklocX = x + this.offsetX;
                                int blocklocZ = z + this.offsetZ;
                                Intrinsics.checkNotNullExpressionValue((Object)this.world.getHighestBlockAt(blocklocX, blocklocZ), (String)"getHighestBlockAt(...)");
                                ChunkLocationMapper.this.getInsideLocations().add(new Location(this.world, (double)block.getX(), (double)block.getY(), (double)block.getZ()));
                            }
                            if (z == end) break;
                            ++z;
                        }
                    }
                    if (x == end) break;
                    ++x;
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/kingdoms/utils/chunks/ChunkLocationMapper$Companion;", "", "<init>", "()V", "CHUNK_SIDES_BLOCKS", "", "getCHUNK_SIDES_BLOCKS$annotations", "getCHUNK_SIDES_BLOCKS", "()I", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int getCHUNK_SIDES_BLOCKS() {
            return CHUNK_SIDES_BLOCKS;
        }

        @JvmStatic
        public static /* synthetic */ void getCHUNK_SIDES_BLOCKS$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

