/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.chunks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.NonNull;
import org.kingdoms.libs.checkerframework.checker.nullness.qual.Nullable;
import org.kingdoms.utils.internal.uuid.FastUUID;

public final class ChunkConnections {
    public static int getConnectionRadius() {
        return KingdomsConfig.Claims.CONNECTION_RADIUS.getManager().getInt();
    }

    public static Location getCentroid(Set<SimpleChunkLocation> chunks) {
        if (chunks.isEmpty()) {
            return null;
        }
        double y = 0.0;
        double totalX = 0.0;
        double totalZ = 0.0;
        SimpleChunkLocation any = null;
        Iterator<SimpleChunkLocation> iterator = chunks.iterator();
        while (iterator.hasNext()) {
            SimpleChunkLocation chunk;
            any = chunk = iterator.next();
            Location center = chunk.getCenterLocation(0.0);
            totalX += center.getX();
            totalZ += center.getZ();
        }
        double centerX = totalX / (double)chunks.size();
        double centerZ = totalZ / (double)chunks.size();
        return new Location(any.getBukkitWorld(), centerX, 0.0, centerZ);
    }

    public static @Nullable Land validateDistance(@NonNull SimpleChunkLocation chunk, @NonNull UUID kingdom) {
        int distance = KingdomsConfig.Claims.DISTANCE.getManager().getInt();
        if (distance <= 0) {
            return null;
        }
        return chunk.findFromSurroundingChunks(distance, c -> {
            Land land = c.getLand();
            if (land != null && land.isClaimed() && !FastUUID.equals(land.getKingdomId(), kingdom)) {
                return land;
            }
            return null;
        });
    }

    public static boolean disconnectsClaimsAfterUnclaim(String world, Kingdom kingdom, int radius, Predicate<SimpleChunkLocation> isGoingToBeUnclaimed) {
        if (radius <= 0) {
            return false;
        }
        Set<SimpleChunkLocation> landsInWorld = kingdom.getLandLocations().stream().filter(x -> x.getWorld().equals(world)).filter(x -> !isGoingToBeUnclaimed.test((SimpleChunkLocation)x)).collect(Collectors.toSet());
        if (landsInWorld.size() == 1) {
            return false;
        }
        return ChunkConnections.getConnectedClusters(radius, landsInWorld).size() > 1;
    }

    public static Set<SimpleChunkLocation> getConnectedChunks(int radius, SimpleChunkLocation chunk, Predicate<SimpleChunkLocation> consider) {
        HashSet<SimpleChunkLocation> connected = new HashSet<SimpleChunkLocation>(radius * radius);
        HashSet<SimpleChunkLocation> checked = new HashSet<SimpleChunkLocation>(radius * radius);
        LinkedList<SimpleChunkLocation> queue = new LinkedList<SimpleChunkLocation>();
        queue.add(chunk);
        while (!queue.isEmpty()) {
            for (SimpleChunkLocation around : ((SimpleChunkLocation)queue.remove()).getChunksAround(radius, false)) {
                if (!consider.test(around)) continue;
                connected.add(around);
                if (!checked.add(around)) continue;
                queue.add(around);
            }
        }
        return connected;
    }

    public static Collection<Set<SimpleChunkLocation>> getConnectedClusters(int radius, Set<SimpleChunkLocation> chunks) {
        if (radius <= 0) {
            throw new IllegalArgumentException("Wrong radius for land clusters: " + radius);
        }
        ArrayList<Set<SimpleChunkLocation>> clusters = new ArrayList<Set<SimpleChunkLocation>>(radius + 1);
        HashSet<SimpleChunkLocation> checked = new HashSet<SimpleChunkLocation>(chunks.size());
        LinkedList<SimpleChunkLocation> queue = new LinkedList<SimpleChunkLocation>();
        for (SimpleChunkLocation chunk : chunks) {
            if (checked.contains(chunk)) continue;
            HashSet<SimpleChunkLocation> cluster = new HashSet<SimpleChunkLocation>(10);
            queue.add(chunk);
            checked.add(chunk);
            cluster.add(chunk);
            while (!queue.isEmpty()) {
                for (SimpleChunkLocation around : ((SimpleChunkLocation)queue.remove()).getChunksAround(radius, false)) {
                    boolean isInCurrentCluster;
                    if (!chunks.contains(around)) continue;
                    boolean wasChecked = !checked.add(around);
                    boolean bl = isInCurrentCluster = !cluster.add(around);
                    if (wasChecked != isInCurrentCluster) {
                        throw new AssertionError((Object)("Chunk cannot co-exist in two clusters: radius=" + radius + " | chunk=" + chunk + " | current=" + around + " (wasChecked=" + wasChecked + ", isInCurrentCluster=" + isInCurrentCluster + ')'));
                    }
                    if (wasChecked || isInCurrentCluster) continue;
                    queue.add(around);
                }
            }
            clusters.add(cluster);
        }
        return clusters;
    }
}

