/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.single;

import org.kingdoms.server.core.Server;
import org.kingdoms.utils.cache.single.CacheableObject;

public class TickedCache<T>
implements CacheableObject<T> {
    private T value;
    private final int expirationTicks;
    private int lastUpdateTicks;

    public TickedCache(int expirationTicks) {
        if (expirationTicks <= 0) {
            throw new IllegalArgumentException("Expiration ticks cannot be less than 1: " + expirationTicks);
        }
        this.expirationTicks = expirationTicks;
    }

    public boolean hasExpired() {
        return this.value == null || Server.get().getTicks() - this.lastUpdateTicks >= this.expirationTicks;
    }

    @Override
    public boolean isCached() {
        return !this.hasExpired();
    }

    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public void invalidate() {
        this.value = null;
    }

    @Override
    public T get() {
        if (this.hasExpired()) {
            throw new IllegalStateException("Cannot access expired value: " + this.value);
        }
        return this.value;
    }

    @Override
    public void set(T value) {
        this.value = value;
        this.update();
    }

    public void update() {
        if (this.value == null) {
            throw new IllegalStateException("Cannot update cache when no value is set: " + this);
        }
        this.lastUpdateTicks = Server.get().getTicks();
    }

    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.expirationTicks + " | " + this.value + ')';
    }
}

