/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.single;

import java.time.Duration;
import java.util.function.Supplier;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.utils.cache.single.CachedSupplier;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u000fB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/kingdoms/utils/cache/single/ExpirableCachedSupplier;", "T", "Lorg/kingdoms/utils/cache/single/CachedSupplier;", "cacheTime", "Ljava/time/Duration;", "getter", "Ljava/util/function/Supplier;", "<init>", "(Ljava/time/Duration;Ljava/util/function/Supplier;)V", "lastChecked", "", "get", "()Ljava/lang/Object;", "toString", "", "Companion", "shared"})
public class ExpirableCachedSupplier<T>
extends CachedSupplier<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Duration cacheTime;
    private long lastChecked;

    public ExpirableCachedSupplier(@NotNull Duration cacheTime, @NotNull Supplier<T> getter) {
        Intrinsics.checkNotNullParameter((Object)cacheTime, (String)"cacheTime");
        Intrinsics.checkNotNullParameter(getter, (String)"getter");
        super(getter);
        this.cacheTime = cacheTime;
        this.lastChecked = System.currentTimeMillis();
        if (this.cacheTime.getSeconds() <= 5L) {
            throw new IllegalArgumentException("Any cache time under 5 seconds is not likely to help with performance: " + this.cacheTime.toMillis() + "ms");
        }
    }

    @Override
    public T get() {
        long currentTime = System.currentTimeMillis();
        long diff = currentTime - this.lastChecked;
        if (this.cached == null || this.cacheTime.minusMillis(diff).isNegative()) {
            this.cached = this.supplier.get();
            this.lastChecked = currentTime;
        }
        Object object = this.cached;
        Intrinsics.checkNotNull((Object)object);
        return (T)object;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + '(' + this.cacheTime + " | " + this.supplier + ')';
    }

    @JvmStatic
    @NotNull
    public static final <T> ExpirableCachedSupplier<T> of(@NotNull Duration cacheTime, @NotNull Supplier<T> getter) {
        return Companion.of(cacheTime, getter);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\u0004\b\u0001\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00060\nH\u0007\u00a8\u0006\u000b"}, d2={"Lorg/kingdoms/utils/cache/single/ExpirableCachedSupplier$Companion;", "", "<init>", "()V", "of", "Lorg/kingdoms/utils/cache/single/ExpirableCachedSupplier;", "T", "cacheTime", "Ljava/time/Duration;", "getter", "Ljava/util/function/Supplier;", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <T> ExpirableCachedSupplier<T> of(@NotNull Duration cacheTime, @NotNull Supplier<T> getter) {
            Intrinsics.checkNotNullParameter((Object)cacheTime, (String)"cacheTime");
            Intrinsics.checkNotNullParameter(getter, (String)"getter");
            return new ExpirableCachedSupplier<T>(cacheTime, getter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

