/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.single;

import java.util.Objects;
import java.util.function.Function;
import org.kingdoms.utils.cache.single.CachedObject;

public class CachedFunction<I, O>
extends CachedObject<O>
implements Function<I, O> {
    protected final Function<I, O> function;

    public CachedFunction(Function<I, O> function) {
        this.function = Objects.requireNonNull(function);
    }

    public static <I, O> CachedFunction<I, O> of(Function<I, O> function) {
        if (function instanceof CachedFunction) {
            return (CachedFunction)function;
        }
        return new CachedFunction<I, O>(function);
    }

    @Override
    public O apply(I input) {
        if (this.cached == null) {
            this.cached = this.function.apply(input);
            this.present = this.cached != null;
        }
        return (O)this.cached;
    }
}

