/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.caffeine;

import java.time.Duration;
import java.util.Objects;
import org.kingdoms.libs.caffeine.cache.Caffeine;
import org.kingdoms.utils.cache.caffeine.ExpirableMap;
import org.kingdoms.utils.cache.caffeine.ExpirationStrategy;
import org.kingdoms.utils.cache.caffeine.ReferencedExpirableObject;

public class ExpirableSet<K> {
    private final ExpirableMap<K, Long> map;
    private final long duration;

    public ExpirableSet(ExpirationStrategy expirationStrategy) {
        Objects.requireNonNull(expirationStrategy, "Expiration etrategies cannot be null");
        this.map = new ExpirableMap(expirationStrategy);
        this.duration = this.map.getDefaultExpirationStrategy().getExpiryAfterCreate().toMillis();
    }

    public ExpirableSet(Caffeine<K, ReferencedExpirableObject<Long>> cache) {
        this.map = new ExpirableMap<K, Long>(cache);
        this.duration = 0L;
    }

    public void add(K key) {
        this.map.put(key, System.currentTimeMillis());
    }

    public Duration getTimeLeft(K key) {
        Long added = this.map.getIfPresent(key);
        if (added == null) {
            return Duration.ZERO;
        }
        long passed = System.currentTimeMillis() - added;
        long left = this.duration - passed;
        return left <= 0L ? Duration.ZERO : Duration.ofMillis(left);
    }

    public void clear() {
        this.map.invalidateAll();
    }

    public boolean contains(K key) {
        return this.map.getIfPresent(key) != null;
    }

    public void remove(K key) {
        this.map.invalidate(key);
    }

    public void cleanUp() {
        this.map.cleanUp();
    }
}

