/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.caffeine;

import com.google.errorprone.annotations.CompatibleWith;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.caffeine.cache.Caffeine;
import org.kingdoms.libs.caffeine.cache.Expiry;
import org.kingdoms.libs.caffeine.cache.Policy;
import org.kingdoms.libs.caffeine.cache.stats.CacheStats;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.Pair;
import org.kingdoms.libs.kotlin.TuplesKt;
import org.kingdoms.libs.kotlin.collections.MapsKt;
import org.kingdoms.libs.kotlin.jvm.JvmOverloads;
import org.kingdoms.libs.kotlin.jvm.functions.Function1;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.kotlin.sequences.Sequence;
import org.kingdoms.utils.cache.caffeine.CacheHandler;
import org.kingdoms.utils.cache.caffeine.ExpirableObjectExpiry;
import org.kingdoms.utils.cache.caffeine.ExpirationStrategy;
import org.kingdoms.utils.cache.caffeine.ReferencedExpirableObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001d\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B\u0015\b\u0017\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB/\b\u0017\u0012\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b0\n\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00172\b\b\u0001\u0010\u001b\u001a\u00020\u0002H\u0016J\u0014\u0010\u001c\u001a\u00020\u00172\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016J#\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u00012\u0006\u0010!\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\"J\u001d\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00028\u00002\u0006\u0010 \u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010%J\u0019\u0010&\u001a\u0004\u0018\u00018\u00012\b\b\u0001\u0010\u001b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u00020)2\u0006\u0010\u001b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010*J.\u0010+\u001a\u00028\u00012\u0006\u0010\u001b\u001a\u00028\u00002\u0016\u0010,\u001a\u0012\u0012\u0006\b\u0000\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u00010-H\u0096\u0002\u00a2\u0006\u0002\u0010.J \u0010/\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001002\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0016JH\u00101\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001002\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u001e2$\u0010,\u001a \u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001000-H\u0016J \u00102\u001a\u0002032\u0016\u00104\u001a\u0012\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0006\b\u0001\u0012\u00028\u000100H\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u000b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010#\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000e\u00a8\u00065"}, d2={"Lorg/kingdoms/utils/cache/caffeine/ExpirableMap;", "K", "", "V", "Lorg/kingdoms/libs/caffeine/cache/Cache;", "defaultExpirationStrategy", "Lorg/kingdoms/utils/cache/caffeine/ExpirationStrategy;", "<init>", "(Lorg/kingdoms/utils/cache/caffeine/ExpirationStrategy;)V", "builder", "Lorg/kingdoms/libs/caffeine/cache/Caffeine;", "Lorg/kingdoms/utils/cache/caffeine/ReferencedExpirableObject;", "(Lcom/github/benmanes/caffeine/cache/Caffeine;Lorg/kingdoms/utils/cache/caffeine/ExpirationStrategy;)V", "getDefaultExpirationStrategy", "()Lorg/kingdoms/utils/cache/caffeine/ExpirationStrategy;", "cache", "estimatedSize", "", "stats", "Lorg/kingdoms/libs/caffeine/cache/stats/CacheStats;", "asMap", "Ljava/util/concurrent/ConcurrentMap;", "cleanUp", "", "policy", "Lorg/kingdoms/libs/caffeine/cache/Policy;", "invalidate", "key", "invalidateAll", "keys", "", "put", "value", "expiry", "(Ljava/lang/Object;Ljava/lang/Object;Lorg/kingdoms/utils/cache/caffeine/ExpirationStrategy;)V", "assertDefaultStrategy", "getAssertDefaultStrategy", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getIfPresent", "(Ljava/lang/Object;)Ljava/lang/Object;", "contains", "", "(Ljava/lang/Object;)Z", "get", "mappingFunction", "Ljava/util/function/Function;", "(Ljava/lang/Object;Ljava/util/function/Function;)Ljava/lang/Object;", "getAllPresent", "", "getAll", "putAll", "", "map", "shared"})
@SourceDebugExtension(value={"SMAP\nExpirableMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpirableMap.kt\norg/kingdoms/utils/cache/caffeine/ExpirableMap\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,95:1\n743#2,4:96\n*S KotlinDebug\n*F\n+ 1 ExpirableMap.kt\norg/kingdoms/utils/cache/caffeine/ExpirableMap\n*L\n82#1:96,4\n*E\n"})
public final class ExpirableMap<K, V>
implements Cache<K, V> {
    @Nullable
    private final ExpirationStrategy defaultExpirationStrategy;
    @NotNull
    private final Cache<K, ReferencedExpirableObject<V>> cache;

    @Nullable
    public final ExpirationStrategy getDefaultExpirationStrategy() {
        return this.defaultExpirationStrategy;
    }

    @JvmOverloads
    public ExpirableMap(@Nullable ExpirationStrategy defaultExpirationStrategy) {
        this.defaultExpirationStrategy = defaultExpirationStrategy;
        this.cache = CacheHandler.newBuilder().expireAfter((Expiry)new ExpirableObjectExpiry()).build();
    }

    public /* synthetic */ ExpirableMap(ExpirationStrategy expirationStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            expirationStrategy = null;
        }
        this(expirationStrategy);
    }

    @JvmOverloads
    public ExpirableMap(@NotNull Caffeine<K, ReferencedExpirableObject<V>> builder, @Nullable ExpirationStrategy defaultExpirationStrategy) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.defaultExpirationStrategy = defaultExpirationStrategy;
        this.cache = builder.build();
        if (defaultExpirationStrategy != null) {
            builder.expireAfter((Expiry)new ExpirableObjectExpiry());
        }
    }

    public /* synthetic */ ExpirableMap(Caffeine caffeine, ExpirationStrategy expirationStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            expirationStrategy = null;
        }
        this(caffeine, expirationStrategy);
    }

    public long estimatedSize() {
        return this.cache.estimatedSize();
    }

    @NotNull
    public CacheStats stats() {
        CacheStats cacheStats = this.cache.stats();
        Intrinsics.checkNotNullExpressionValue((Object)cacheStats, (String)"stats(...)");
        return cacheStats;
    }

    @NotNull
    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    @NotNull
    public Policy<K, V> policy() {
        throw new UnsupportedOperationException();
    }

    public void invalidate(@CompatibleWith(value="K") @NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.cache.invalidate(key);
    }

    public void invalidateAll(@NotNull Iterable<?> keys) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        this.cache.invalidateAll(keys);
    }

    public final void put(@NotNull K key, @NotNull V value, @NotNull ExpirationStrategy expiry) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)expiry, (String)"expiry");
        this.cache.put(key, new ReferencedExpirableObject<V>(value, expiry));
    }

    private final ExpirationStrategy getAssertDefaultStrategy() {
        ExpirationStrategy expirationStrategy = this.defaultExpirationStrategy;
        if (expirationStrategy == null) {
            throw new UnsupportedOperationException("No default expiration strategy was set");
        }
        return expirationStrategy;
    }

    public void put(@NotNull K key, @NotNull V value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.cache.put(key, new ReferencedExpirableObject<V>(value, this.getAssertDefaultStrategy()));
    }

    @Nullable
    public V getIfPresent(@CompatibleWith(value="K") @NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ReferencedExpirableObject referencedExpirableObject = (ReferencedExpirableObject)this.cache.getIfPresent(key);
        return (V)(referencedExpirableObject != null ? referencedExpirableObject.getReference() : null);
    }

    public final boolean contains(@NotNull K key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return this.cache.getIfPresent(key) != null;
    }

    @NotNull
    public V get(@NotNull K key, @NotNull Function<? super K, ? extends V> mappingFunction) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        Object object = this.cache.get(key, arg_0 -> ExpirableMap.get$lambda$1(arg_0 -> ExpirableMap.get$lambda$0(mappingFunction, key, this, arg_0), arg_0));
        Intrinsics.checkNotNull((Object)object);
        return (V)((ReferencedExpirableObject)object).getReference();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<K, V> getAllPresent(@NotNull Iterable<?> keys) {
        void var3_3;
        void $this$associateTo$iv;
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Map map = this.cache.getAllPresent(keys);
        Object object = map != null ? MapsKt.asSequence((Map)map) : null;
        Intrinsics.checkNotNull((Object)object);
        Sequence sequence = object;
        Map destination$iv = new HashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv : $this$associateTo$iv) {
            Map map2 = destination$iv;
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), ((ReferencedExpirableObject)it.getValue()).getReference());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return var3_3;
    }

    @NotNull
    public Map<K, V> getAll(@NotNull Iterable<? extends K> keys, @NotNull Function<Iterable<K>, Map<K, V>> mappingFunction) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter(mappingFunction, (String)"mappingFunction");
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void putAll(@NotNull Map<? extends K, ? extends V> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        throw new UnsupportedOperationException();
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @JvmOverloads
    public ExpirableMap() {
        this(null, 1, null);
    }

    @JvmOverloads
    public ExpirableMap(@NotNull Caffeine<K, ReferencedExpirableObject<V>> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this(builder, null, 2, null);
    }

    private static final ReferencedExpirableObject get$lambda$0(Function $mappingFunction, Object $key, ExpirableMap this$0, Object it) {
        return new ReferencedExpirableObject($mappingFunction.apply($key), this$0.getAssertDefaultStrategy());
    }

    private static final ReferencedExpirableObject get$lambda$1(Function1 $tmp0, Object p0) {
        return (ReferencedExpirableObject)$tmp0.invoke(p0);
    }
}

