/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache.caffeine;

import java.util.Objects;
import org.kingdoms.libs.caffeine.cache.Cache;
import org.kingdoms.libs.caffeine.cache.Caffeine;

public class CacheSet<K> {
    private final Cache<K, Boolean> map;

    public CacheSet(Caffeine<K, Boolean> builder) {
        Objects.requireNonNull(builder, "Builder is null");
        this.map = builder.build();
    }

    public void add(K key) {
        this.map.put(key, (Object)true);
    }

    public void clear() {
        this.map.invalidateAll();
    }

    public boolean contains(K key) {
        return this.map.getIfPresent(key) != null;
    }

    public void remove(K key) {
        this.map.invalidate(key);
    }

    public void cleanUp() {
        this.map.cleanUp();
    }

    public boolean isEmpty() {
        return this.map.asMap().isEmpty();
    }
}

