/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.cache;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/utils/cache/RunnableCountDownLatch;", "", "countdown", "", "runnable", "Ljava/util/function/Consumer;", "<init>", "(ILjava/util/function/Consumer;)V", "Ljava/util/concurrent/atomic/AtomicInteger;", "total", "getTotal", "()Ljava/util/concurrent/atomic/AtomicInteger;", "increase", "", "countDown", "shared"})
@SourceDebugExtension(value={"SMAP\nRunnableCountDownLatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RunnableCountDownLatch.kt\norg/kingdoms/utils/cache/RunnableCountDownLatch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,25:1\n1#2:26\n*E\n"})
public final class RunnableCountDownLatch {
    @NotNull
    private final Consumer<RunnableCountDownLatch> runnable;
    @NotNull
    private final AtomicInteger countdown;
    @NotNull
    private final AtomicInteger total;

    public RunnableCountDownLatch(int countdown, @NotNull Consumer<RunnableCountDownLatch> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        this.runnable = runnable;
        if (!(countdown > 0)) {
            boolean bl = false;
            String string = "Countdown number must be greater than zero";
            throw new IllegalArgumentException(string.toString());
        }
        this.countdown = new AtomicInteger(countdown);
        this.total = new AtomicInteger(countdown);
    }

    @NotNull
    public final AtomicInteger getTotal() {
        return this.total;
    }

    public final void increase() {
        this.countdown.incrementAndGet();
        this.total.incrementAndGet();
    }

    public final void countDown() {
        if (this.countdown.get() <= 0) {
            throw new IllegalStateException("Already down to zero: " + this.countdown.get());
        }
        if (this.countdown.decrementAndGet() == 0) {
            this.runnable.accept(this);
        }
    }
}

