/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils.bossbars;

import com.google.common.base.Enums;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.collections.ArraysKt;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.compiler.MessageCompiler;
import org.kingdoms.locale.compiler.MessageObject;
import org.kingdoms.utils.config.ConfigSection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0019\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00020\u001bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u0006%"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarSettings;", "", "rawTitle", "", "color", "Lorg/bukkit/boss/BarColor;", "style", "Lorg/bukkit/boss/BarStyle;", "flags", "", "Lorg/bukkit/boss/BarFlag;", "<init>", "(Ljava/lang/String;Lorg/bukkit/boss/BarColor;Lorg/bukkit/boss/BarStyle;[Lorg/bukkit/boss/BarFlag;)V", "getColor$core", "()Lorg/bukkit/boss/BarColor;", "setColor$core", "(Lorg/bukkit/boss/BarColor;)V", "getStyle$core", "()Lorg/bukkit/boss/BarStyle;", "setStyle$core", "(Lorg/bukkit/boss/BarStyle;)V", "getFlags$core", "()[Lorg/bukkit/boss/BarFlag;", "setFlags$core", "([Lorg/bukkit/boss/BarFlag;)V", "[Lorg/bukkit/boss/BarFlag;", "title", "Lorg/kingdoms/locale/compiler/MessageObject;", "getTitle$core", "()Lorg/kingdoms/locale/compiler/MessageObject;", "setTitle$core", "(Lorg/kingdoms/locale/compiler/MessageObject;)V", "toString", "", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "Companion", "core"})
public class BossBarSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String rawTitle;
    @NotNull
    private BarColor color;
    @NotNull
    private BarStyle style;
    @NotNull
    private BarFlag[] flags;
    @NotNull
    private MessageObject title;

    public BossBarSettings(@NotNull String rawTitle, @NotNull BarColor color, @NotNull BarStyle style, BarFlag ... flags) {
        Intrinsics.checkNotNullParameter((Object)rawTitle, (String)"rawTitle");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)flags, (String)"flags");
        this.rawTitle = rawTitle;
        this.color = color;
        this.style = style;
        this.flags = flags;
        MessageObject messageObject = MessageCompiler.compile(this.rawTitle);
        Intrinsics.checkNotNullExpressionValue((Object)messageObject, (String)"compile(...)");
        this.title = messageObject;
    }

    @NotNull
    public final BarColor getColor$core() {
        return this.color;
    }

    public final void setColor$core(@NotNull BarColor barColor) {
        Intrinsics.checkNotNullParameter((Object)barColor, (String)"<set-?>");
        this.color = barColor;
    }

    @NotNull
    public final BarStyle getStyle$core() {
        return this.style;
    }

    public final void setStyle$core(@NotNull BarStyle barStyle) {
        Intrinsics.checkNotNullParameter((Object)barStyle, (String)"<set-?>");
        this.style = barStyle;
    }

    @NotNull
    public final BarFlag[] getFlags$core() {
        return this.flags;
    }

    public final void setFlags$core(@NotNull BarFlag[] barFlagArray) {
        Intrinsics.checkNotNullParameter((Object)barFlagArray, (String)"<set-?>");
        this.flags = barFlagArray;
    }

    @NotNull
    public final MessageObject getTitle$core() {
        return this.title;
    }

    public final void setTitle$core(@NotNull MessageObject messageObject) {
        Intrinsics.checkNotNullParameter((Object)messageObject, (String)"<set-?>");
        this.title = messageObject;
    }

    public final void toString(@NotNull ConfigSection section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        section.set("title", (Object)this.rawTitle);
        section.set("color", (Object)this.color.name());
        section.set("style", (Object)this.style.name());
        section.set("flags", (Object)ArraysKt.toList((Object[])this.flags));
    }

    @JvmStatic
    @NotNull
    public static final BossBarSettings fromSection(@NotNull ConfigSection section) {
        return Companion.fromSection(section);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/kingdoms/utils/bossbars/BossBarSettings$Companion;", "", "<init>", "()V", "fromSection", "Lorg/kingdoms/utils/bossbars/BossBarSettings;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "core"})
    @SourceDebugExtension(value={"SMAP\nBossBarSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BossBarSettings.kt\norg/kingdoms/utils/bossbars/BossBarSettings$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,51:1\n37#2:52\n36#2,3:53\n*S KotlinDebug\n*F\n+ 1 BossBarSettings.kt\norg/kingdoms/utils/bossbars/BossBarSettings$Companion\n*L\n48#1:52\n48#1:53,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BossBarSettings fromSection(@NotNull ConfigSection section) {
            BarStyle barStyle;
            BarColor barColor;
            String colorStr;
            String title;
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            String string = section.getString("title");
            if (string == null) {
                string = title = "";
            }
            if ((colorStr = section.getString("color")) == null) {
                barColor = BarColor.WHITE;
            } else {
                String string2 = colorStr;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string3 = string2.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                barColor = (BarColor)Enums.getIfPresent(BarColor.class, (String)string3).or((Object)BarColor.WHITE);
            }
            BarColor color = barColor;
            String styleStr = section.getString("style");
            if (styleStr == null) {
                barStyle = BarStyle.SOLID;
            } else {
                String string4 = styleStr;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string5 = string4.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toUpperCase(...)");
                barStyle = (BarStyle)Enums.getIfPresent(BarStyle.class, (String)string5).or((Object)BarStyle.SOLID);
            }
            BarStyle style = barStyle;
            Object object = new String[]{"flags"};
            List<String> list = section.getStringList((String[])object);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStringList(...)");
            List<String> flagList = list;
            List flags = new ArrayList(flagList.size());
            for (String flagName : flagList) {
                Intrinsics.checkNotNull((Object)flagName);
                String string6 = flagName;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
                String string7 = string6.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toUpperCase(...)");
                BarFlag flag = (BarFlag)Enums.getIfPresent(BarFlag.class, (String)string7).orNull();
                if (flag == null) continue;
                flags.add(flag);
            }
            Intrinsics.checkNotNull((Object)color);
            Intrinsics.checkNotNull((Object)style);
            Collection $this$toTypedArray$iv = flags;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            object = thisCollection$iv.toArray(new BarFlag[0]);
            return new BossBarSettings(title, color, style, (BarFlag[])Arrays.copyOf(object, ((Object)object).length));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

