/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import java.util.List;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.locale.messenger.CombinedMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.ProcessedMessenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.utils.MathUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000f"}, d2={"Lorg/kingdoms/utils/TextProgressBar;", "", "progress", "", "barCount", "", "<init>", "(DI)V", "getProgress", "()D", "getBarCount", "()I", "progressMessage", "Lorg/kingdoms/locale/messenger/Messenger;", "getPercent", "core"})
@SourceDebugExtension(value={"SMAP\nTextProgressBar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextProgressBar.kt\norg/kingdoms/utils/TextProgressBar\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n1#2:39\n*E\n"})
public final class TextProgressBar {
    private final double progress;
    private final int barCount;

    public TextProgressBar(double progress, int barCount) {
        this.progress = progress;
        this.barCount = barCount;
        double d = this.progress;
        if (!(0.0 <= d ? d <= 1.0 : false)) {
            boolean $i$a$-require-TextProgressBar$32 = false;
            String $i$a$-require-TextProgressBar$32 = "Progress must be between 0.0 and 1.0 got " + this.progress;
            throw new IllegalArgumentException($i$a$-require-TextProgressBar$32.toString());
        }
        int n = this.barCount;
        if (!(1 <= n ? n < 10001 : false)) {
            boolean bl = false;
            String string = "Progress bar count be between 1 and 10,000 got " + this.progress;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final double getProgress() {
        return this.progress;
    }

    public final int getBarCount() {
        return this.barCount;
    }

    @NotNull
    public final Messenger progressMessage() {
        int progressedBarCount = (int)((double)this.barCount * this.progress);
        int remainingBarCount = this.barCount - progressedBarCount;
        StaticMessenger activeColor = new StaticMessenger("&2");
        StaticMessenger activeBar = new StaticMessenger("\u2503");
        StaticMessenger inactiveColor = new StaticMessenger("&8");
        StaticMessenger inactiveBar = new StaticMessenger("\u2503");
        List messageList = new ArrayList();
        if (progressedBarCount != 0) {
            messageList.add(activeColor);
            messageList.add(new ProcessedMessenger(activeBar, new ProcessedMessenger.RepeatProcessor(progressedBarCount)));
        }
        if (remainingBarCount != 0) {
            messageList.add(inactiveColor);
            messageList.add(new ProcessedMessenger(inactiveBar, new ProcessedMessenger.RepeatProcessor(remainingBarCount)));
        }
        return new CombinedMessenger(messageList);
    }

    public final double getPercent() {
        return MathUtils.roundToDigits(this.progress * 100.0, 1);
    }
}

