/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import org.kingdoms.data.Pair;
import org.kingdoms.locale.ContextualMessageSender;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.utils.internal.numbers.AnyNumber;
import org.kingdoms.utils.internal.numbers.NumberProcessor;

public final class ProcessToMessage {
    private ProcessToMessage() {
    }

    public static AnyNumber getNumberOrError(NumberProcessor number, Object argName, ContextualMessageSender messenger) {
        Pair<AnyNumber, Messenger> processed = ProcessToMessage.getNumber(number);
        if (processed.getValue() != null) {
            messenger.getMessageContext().raw("arg", number.getString()).raw("needed", argName);
            messenger.sendError(processed.getValue(), new Object[0]);
            return null;
        }
        return processed.getKey();
    }

    public static Pair<AnyNumber, Messenger> getNumber(NumberProcessor number) {
        number.process();
        if (!number.isSuccessful()) {
            Messenger failMessage;
            switch (number.getMostImportantFailure()) {
                case NOT_A_NUMBER: {
                    failMessage = KingdomsLang.INVALID_NUMBER;
                    break;
                }
                case OUT_OF_BOUNDS: {
                    failMessage = KingdomsLang.INVALID_NUMBER_TOO_LARGE;
                    break;
                }
                case POSITIVE: {
                    failMessage = KingdomsLang.INVALID_NUMBER_NEGATIVE;
                    break;
                }
                case INTEGER_ONLY: {
                    failMessage = KingdomsLang.INVALID_NUMBER_INTEGER_ONLY;
                    break;
                }
                default: {
                    failMessage = new StaticMessenger("Unknown number error: " + number.getString() + " -> " + number.getFailedConstraints());
                }
            }
            return Pair.of(number.getNumber(), failMessage);
        }
        return Pair.of(number.getNumber(), null);
    }
}

