/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeInstance;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.xseries.XAttribute;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.locale.placeholders.context.PlaceholderContextBuilder;
import org.kingdoms.utils.LocationUtils;
import org.kingdoms.utils.MathUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007\u00a8\u0006\f"}, d2={"Lorg/kingdoms/utils/PlaceholderContextProviders;", "", "<init>", "()V", "provide", "", "context", "Lorg/kingdoms/locale/placeholders/context/PlaceholderContextBuilder;", "entity", "Lorg/bukkit/entity/Entity;", "item", "Lorg/bukkit/inventory/ItemStack;", "core"})
public final class PlaceholderContextProviders {
    @NotNull
    public static final PlaceholderContextProviders INSTANCE = new PlaceholderContextProviders();

    private PlaceholderContextProviders() {
    }

    @JvmStatic
    public static final void provide(@NotNull PlaceholderContextBuilder context, @NotNull Entity entity2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)entity2, (String)"entity");
        Object[] objectArray = new Object[]{"displayname", entity2.getCustomName(), "name", entity2.getName(), "location", KingdomsLang.LOCATIONS_NORMAL.parse((MessagePlaceholderProvider)LocationUtils.getLocationEdits((PlaceholderContextBuilder)new MessagePlaceholderProvider(), SimpleLocation.of(entity2.getLocation()), ""))};
        context.raws(objectArray);
        if (entity2 instanceof LivingEntity) {
            PlaceholderContextBuilder placeholderContextBuilder = context.raw("health", MathUtils.roundToDigits(((LivingEntity)entity2).getHealth(), 2));
            LivingEntity livingEntity = (LivingEntity)entity2;
            Object object = XAttribute.MAX_HEALTH.get();
            Intrinsics.checkNotNull((Object)object);
            AttributeInstance attributeInstance = livingEntity.getAttribute((Attribute)object);
            placeholderContextBuilder.raw("max_health", MathUtils.roundToDigits(attributeInstance != null ? attributeInstance.getValue() : 0.0, 2));
        }
    }

    @JvmStatic
    public static final void provide(@NotNull PlaceholderContextBuilder context, @NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ItemMeta meta = item.getItemMeta();
        MessagePlaceholderProvider messagePlaceholderProvider = new MessagePlaceholderProvider().raw("amount", item.getAmount());
        ItemMeta itemMeta = meta;
        Intrinsics.checkNotNull((Object)itemMeta);
        context.addChild("item", messagePlaceholderProvider.parse("displayname", itemMeta.getDisplayName()));
    }
}

