/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.kingdoms.commands.CommandContext;
import org.kingdoms.commands.KingdomsCommand;
import org.kingdoms.commands.KingdomsParentCommand;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.libs.xseries.XSound;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.compiler.builders.MessageObjectLinker;
import org.kingdoms.locale.messenger.DefaultedMessenger;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.utils.Validate;

public final class PaginatedCommandHelp {
    private final CommandContext context;
    private final int itemsPerPage;
    private final Supplier<KingdomsCommand[]> supplier;
    private final Messenger group;

    public PaginatedCommandHelp(CommandContext context, int itemsPerPage, Messenger group, Supplier<KingdomsCommand[]> supplier) {
        this.context = context;
        this.itemsPerPage = itemsPerPage;
        this.supplier = supplier;
        this.group = group;
        Validate.isTrue(itemsPerPage > 0, "Items per page must be positive: " + itemsPerPage);
    }

    public int getPageNumbers(int commands) {
        return commands % this.itemsPerPage != 0 ? commands / this.itemsPerPage + 1 : commands / this.itemsPerPage;
    }

    public void execute() {
        if (this.context.isPlayer()) {
            XSound.ITEM_BOOK_PAGE_TURN.record().soundPlayer().forPlayers(new Player[]{this.context.senderAsPlayer()}).play();
        }
        String commandName = this.context.getCommand().getName();
        int page = 0;
        if (this.context.assertArgs(1)) {
            try {
                page = Integer.parseInt(this.context.arg(0)) - 1;
                if (page + 1 < 1) {
                    this.context.sendError(KingdomsLang.COMMAND_HELP_NEGATIVE_PAGES, new Object[0]);
                    return;
                }
            }
            catch (NumberFormatException e) {
                this.context.sendError(KingdomsLang.COMMANDS_UNKNOWN_COMMAND, "cmd", commandName);
                return;
            }
        }
        KingdomsCommand[] commands = this.supplier.get();
        int eachPage = KingdomsConfig.HELP_COMMANDS.getInt();
        int maxPages = this.getPageNumbers(commands.length);
        List<KingdomsCommand> selectedCmds = Arrays.stream(commands).skip((long)page * (long)eachPage).limit(eachPage).collect(Collectors.toList());
        this.context.getMessageContext().raw("max_pages", maxPages).raw("previous_page", page).raw("page", page + 1).raw("group", this.group).raw("next_page", page + 2).raw("command", commandName);
        if (selectedCmds.isEmpty()) {
            this.context.sendError(KingdomsLang.COMMAND_HELP_NO_MORE_PAGES, new Object[0]);
            return;
        }
        this.context.sendMessage((Messenger)(maxPages == 1 ? KingdomsLang.COMMAND_HELP_HEADER_UNPAGINATED : KingdomsLang.COMMAND_HELP_HEADER_PAGINATED), new Object[0]);
        selectedCmds.forEach(cmd -> {
            StringBuilder name = new StringBuilder(cmd.getDisplayName().parse(this.context.getMessageContext()));
            for (KingdomsParentCommand group = cmd.getParent(); group != null; group = group.getParent()) {
                name.insert(0, group.getDisplayName().parse(this.context.getMessageContext()) + ' ');
            }
            String usage = cmd.getUsage().parse(this.context.getMessageReceiver(), new Object[0]);
            if (usage == null) {
                usage = "";
            }
            this.context.var("cmd", name.toString()).var("usage", usage).var("command", commandName);
            this.context.getMessageContext().raw("description", DefaultedMessenger.of(cmd.getDescription(), KingdomsLang.NONE));
            this.context.sendMessage((Messenger)KingdomsLang.COMMAND_HELP_COMMANDS, new Object[0]);
        });
        if (maxPages == 1) {
            return;
        }
        MessageObjectLinker linker = new MessageObjectLinker();
        int footerPages = KingdomsConfig.HELP_FOOTER_PAGES.getInt();
        int startPages = 1;
        int endPages = maxPages;
        if (endPages * 2 + 1 > footerPages) {
            if (page - footerPages < 0 && endPages > footerPages + page) {
                endPages = Math.min(footerPages * 2, maxPages);
            } else if (page + footerPages > endPages && page - footerPages * 2 > 0) {
                startPages = endPages - footerPages * 2;
            } else {
                endPages = Math.min(endPages, page + 1 + footerPages);
                startPages = Math.max(1, page + 1 - footerPages);
            }
        }
        for (int pages = startPages; pages <= endPages; ++pages) {
            MessagePlaceholderProvider subSettings = new MessagePlaceholderProvider().raws("number", pages, "previous_page", page, "page", page + 1, "next_page", page + 2, "max_pages", maxPages, "command", commandName);
            if (pages == page + 1) {
                linker.add(KingdomsLang.COMMAND_HELP_FOOTER_CURRENT_PAGE, subSettings);
            } else {
                linker.add(KingdomsLang.COMMAND_HELP_FOOTER_PAGE, subSettings);
            }
            linker.add(" ");
        }
        this.context.getMessageContext().raw("pages", linker);
        this.context.sendMessage((Messenger)KingdomsLang.COMMAND_HELP_FOOTER_MAIN, new Object[0]);
    }
}

