/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.NumberConversions;
import org.kingdoms.libs.xseries.reflection.XReflection;
import org.kingdoms.libs.xseries.reflection.jvm.FieldMemberHandle;
import org.kingdoms.libs.xseries.reflection.jvm.classes.ClassHandle;
import org.kingdoms.libs.xseries.reflection.jvm.classes.DynamicClassHandle;
import org.kingdoms.libs.xseries.reflection.jvm.classes.StaticClassHandle;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftClassHandle;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftConnection;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftMapping;
import org.kingdoms.libs.xseries.reflection.minecraft.MinecraftPackage;
import org.kingdoms.libs.xseries.reflection.minecraft.NMSExtras;
import org.kingdoms.utils.Validate;

public final class Laser {
    private static final String TEAM = "kingdoms";
    private static final String COLLISION_RULE = "never";
    private static final AtomicInteger TEAM_ID = new AtomicInteger();
    private static final AtomicInteger LAST_ISSUED_EID = new AtomicInteger(2000000000);
    private final int duration;
    private final int distanceSquared;
    private final Object createGuardianPacket;
    private final Object createSquidPacket;
    private final Object destroyPacket;
    private final Object metadataPacketGuardian;
    private final Object metadataPacketSquid;
    private final Object fakeGuardianDataWatcher;
    private final Object teamCreatePacket;
    private final Map<UUID, Player> players = new ConcurrentHashMap<UUID, Player>(10);
    private final Set<Integer> seen = new HashSet<Integer>();
    private final NMSEntityInfo squid;
    private final NMSEntityInfo guardian;
    private Location start;
    private Location lastEndLocation;
    private Supplier<Location> endLocationTracker;
    private BukkitRunnable run;

    public Laser(Location start, Supplier<Location> endLocationTracker, int duration, int distance) throws ReflectiveOperationException {
        Object guardian;
        Object squid;
        Location end = endLocationTracker.get();
        if (start.getWorld() != end.getWorld()) {
            throw new IllegalArgumentException("Laser start world is different from the end location: " + start.getWorld() + " - " + end.getWorld());
        }
        this.start = start;
        this.endLocationTracker = endLocationTracker;
        this.duration = duration;
        this.distanceSquared = distance * distance;
        if (XReflection.supports((int)17)) {
            squid = NMSReflection.createSquid(end);
            this.createSquidPacket = NMSReflection.createPacketEntitySpawn(squid);
        } else {
            squid = null;
            this.createSquidPacket = NMSReflection.createSpawnPacket(end, NMSReflection.SQUID_TYPE);
        }
        String UUIDFieldName = (String)XReflection.v((int)21, (Object)"e").v(19, (Object)"d").orElse((Object)"b");
        String EntityIdFieldName = (String)XReflection.v((int)21, (Object)"d").v(19, (Object)"c").orElse((Object)"a");
        UUID squidUUID = (UUID)NMSReflection.getField(UUIDFieldName, this.createSquidPacket);
        int squidId = (Integer)NMSReflection.getField(EntityIdFieldName, this.createSquidPacket);
        this.squid = new NMSEntityInfo(squid, squidUUID, squidId);
        this.metadataPacketSquid = NMSReflection.createPacketMetadata(squidId, NMSReflection.fakeSquidWatcher);
        NMSReflection.setDirtyWatcher(NMSReflection.fakeSquidWatcher);
        if (XReflection.supports((int)17)) {
            guardian = NMSReflection.createGuardian(start);
            this.createGuardianPacket = NMSReflection.createPacketEntitySpawn(guardian);
        } else {
            guardian = null;
            this.createGuardianPacket = NMSReflection.createSpawnPacket(start, NMSReflection.GUARDIAN_TYPE);
        }
        this.fakeGuardianDataWatcher = NMSReflection.initGuardianWatcher(guardian, squidId);
        UUID guardianUUID = (UUID)NMSReflection.getField(UUIDFieldName, this.createGuardianPacket);
        int guardianId = (Integer)NMSReflection.getField(EntityIdFieldName, this.createGuardianPacket);
        this.guardian = new NMSEntityInfo(guardian, guardianUUID, guardianId);
        this.metadataPacketGuardian = NMSReflection.createPacketMetadata(guardianId, this.fakeGuardianDataWatcher);
        this.teamCreatePacket = NMSReflection.createPacketTeamAddEntities(squidUUID, guardianUUID);
        this.destroyPacket = NMSReflection.createPacketRemoveEntities(squidId, guardianId);
    }

    private static double distanceSquared(Location start, Location location) {
        return NumberConversions.square((double)(start.getX() - location.getX())) + NumberConversions.square((double)(start.getY() - location.getY())) + NumberConversions.square((double)(start.getZ() - location.getZ()));
    }

    public void start(final Plugin plugin) {
        if (this.run != null) {
            throw new IllegalStateException("Laser is already started");
        }
        this.run = new BukkitRunnable(){
            final World world;
            int time;
            {
                this.world = Laser.this.start.getWorld();
                this.time = Laser.this.duration;
            }

            public void run() {
                for (Player player : this.world.getPlayers()) {
                    if (Laser.this.isCloseEnough(player.getLocation())) {
                        if (Laser.this.players.put(player.getUniqueId(), player) != null) continue;
                        Laser.this.sendStartPackets(plugin, player, !Laser.this.seen.add(player.getEntityId()));
                        continue;
                    }
                    if (Laser.this.players.remove(player.getUniqueId()) == null) continue;
                    Laser.this.destroy(player);
                }
                if (--this.time == 0) {
                    this.cancel();
                }
                try {
                    Location end = Laser.this.getEndLocation();
                    if (end != null) {
                        Object packet = NMSReflection.teleport(Laser.this.squid, end);
                        for (Player player : Laser.this.players.values()) {
                            MinecraftConnection.sendPacket((Player)player, (Object[])new Object[]{packet});
                        }
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }

            public synchronized void cancel() throws IllegalStateException {
                super.cancel();
                Laser.this.run = null;
                for (Player player : Laser.this.players.values()) {
                    Laser.this.destroy(player);
                }
                Laser.this.players.clear();
            }
        };
        this.run.runTaskTimerAsynchronously(plugin, 0L, 20L);
    }

    public void destroy(Player player) {
        MinecraftConnection.sendPacket((Player)player, (Object[])new Object[]{this.destroyPacket});
    }

    public void clear() {
        this.players.clear();
    }

    public void stop() {
        Validate.isTrue(this.run != null, "Laser not started");
        this.run.cancel();
    }

    public void moveStart(Location location) throws ReflectiveOperationException {
        this.start = location;
        Object packet = NMSReflection.teleport(this.guardian, this.start);
        for (Player player : this.players.values()) {
            MinecraftConnection.sendPacket((Player)player, (Object[])new Object[]{packet});
        }
    }

    public Location getStart() {
        return this.start;
    }

    public void moveEnd(Supplier<Location> endLocationTracker) throws ReflectiveOperationException {
        this.endLocationTracker = endLocationTracker;
    }

    public void callColorChange() {
        for (Player player : this.players.values()) {
            MinecraftConnection.sendPacket((Player)player, (Object[])new Object[]{this.metadataPacketGuardian});
        }
    }

    public boolean isStarted() {
        return this.run != null;
    }

    private void sendStartPackets(Plugin plugin, Player player, boolean hasSeen) {
        ArrayList<Object> packets = new ArrayList<Object>(6);
        Bukkit.getScheduler().runTaskLaterAsynchronously(plugin, () -> {
            Location end;
            packets.clear();
            packets.add(this.createGuardianPacket);
            if (XReflection.supports((int)15)) {
                packets.add(this.metadataPacketGuardian);
            }
            if (!hasSeen) {
                packets.add(this.teamCreatePacket);
            }
            if ((end = this.getEndLocation()) != null) {
                try {
                    packets.add(NMSReflection.teleport(this.squid, end));
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            MinecraftConnection.sendPacket((Player)player, (Object[])packets.toArray());
        }, 5L);
        packets.add(this.createSquidPacket);
        if (XReflection.supports((int)15)) {
            packets.add(this.metadataPacketSquid);
        }
        MinecraftConnection.sendPacket((Player)player, (Object[])packets.toArray());
    }

    private boolean isCloseEnough(Location location) {
        return Laser.distanceSquared(this.start, location) <= (double)this.distanceSquared || this.lastEndLocation != null && Laser.distanceSquared(this.lastEndLocation, location) <= (double)this.distanceSquared;
    }

    private Location getEndLocation() {
        Location end = this.endLocationTracker.get();
        return end == null ? this.lastEndLocation : (this.lastEndLocation = end);
    }

    private static final class NMSEntityInfo {
        private final Object entity;
        private final UUID uuid;
        private final int id;

        private NMSEntityInfo(Object entity2, UUID uuid, int id) {
            this.entity = entity2;
            this.uuid = uuid;
            this.id = id;
        }
    }

    private static final class NMSReflection {
        private static final MethodHandle PACKET_SPAWN;
        private static final MethodHandle SET_LOCATION;
        private static final MethodHandle BlockPositionCtor;
        private static final Object NMS_WORLD;
        private static final int TEAM_METHOD_ADD = 3;
        private static final Class<?> packetRemove;
        private static final Class<?> packetTeleport;
        private static final Class<?> packetTeam;
        private static final Class<?> packetMetadata;
        private static Constructor<?> watcherConstructor;
        private static Method watcherSet;
        private static Method watcherRegister;
        private static Method watcherDirty;
        private static Method watcherPack;
        private static Object WATCHER_INVISILIBITY;
        private static Object WATCHER_SPIKES;
        private static Object WATCHER_ATTACK_ID;
        private static Object SQUID_TYPE;
        private static Object GUARDIAN_TYPE;
        private static Object fakeSquidEntity;
        private static Object fakeSquidWatcher;
        private static Object WatcherItemEmptyArray;
        private static final Class<?> guardian;
        private static MethodHandle Entity$defineSynchedData;
        private static MethodHandle SynchedEntityData$Builder_Ctor;
        private static MethodHandle SynchedEntityData$Builder_define;
        private static MethodHandle SynchedEntityData$Builder_build;
        private static final Class<?> squid;

        private NMSReflection() {
        }

        private static int generateEID() {
            return LAST_ISSUED_EID.getAndIncrement();
        }

        public static void setDirtyWatcher(Object watcher) throws ReflectiveOperationException {
            if (XReflection.supports((int)15)) {
                watcherDirty.invoke(watcher, WATCHER_INVISILIBITY);
            }
        }

        public static Object createSquid(Location location) throws ReflectiveOperationException {
            Object entity2 = squid.getDeclaredConstructors()[0].newInstance(SQUID_TYPE, NMS_WORLD);
            NMSReflection.setLocation(entity2, location);
            return entity2;
        }

        public static Object createGuardian(Location location) throws ReflectiveOperationException {
            Object entity2 = guardian.getDeclaredConstructors()[0].newInstance(GUARDIAN_TYPE, NMS_WORLD);
            NMSReflection.setLocation(entity2, location);
            return entity2;
        }

        public static Object createSpawnPacket(Location location, Object entityType) {
            try {
                Object packet = PACKET_SPAWN.invoke();
                NMSReflection.setField(packet, "a", NMSReflection.generateEID());
                NMSReflection.setField(packet, "b", UUID.randomUUID());
                NMSReflection.setField(packet, "c", entityType);
                NMSReflection.setField(packet, "d", location.getX());
                NMSReflection.setField(packet, "e", location.getY());
                NMSReflection.setField(packet, "f", location.getZ());
                NMSReflection.setField(packet, "j", (byte)(location.getYaw() * 256.0f / 360.0f));
                NMSReflection.setField(packet, "k", (byte)(location.getPitch() * 256.0f / 360.0f));
                if (!XReflection.supports((int)15)) {
                    NMSReflection.setField(packet, "m", fakeSquidWatcher);
                }
                return packet;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public static Object initGuardianWatcher(Object guardian, int squidId) throws ReflectiveOperationException {
            return NMSReflection.createDataWatcher(guardian, Arrays.asList(new WatcherPair(WATCHER_INVISILIBITY, (byte)32), new WatcherPair(WATCHER_SPIKES, false), new WatcherPair(WATCHER_ATTACK_ID, squidId)));
        }

        public static Object createPacketEntitySpawn(Object entity2) {
            try {
                if (XReflection.supports((int)21)) {
                    return PACKET_SPAWN.invoke(entity2, 0, BlockPositionCtor.invoke(0, 0, 0));
                }
                return PACKET_SPAWN.invoke(entity2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return null;
            }
        }

        public static Object createPacketRemoveEntities(int squidId, int guardianId) throws ReflectiveOperationException {
            if (XReflection.supports((int)17)) {
                Constructor<?> ctor = packetRemove.getConstructor(int[].class);
                return ctor.newInstance(new Object[]{new int[]{squidId, guardianId}});
            }
            Object packet = packetRemove.newInstance();
            NMSReflection.setField(packet, "a", new int[]{squidId, guardianId});
            return packet;
        }

        public static void setLocation(Object entity2, Location location) {
            try {
                SET_LOCATION.invoke(entity2, location.getX(), location.getY(), location.getZ(), location.getPitch(), location.getYaw());
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public static Object createPacketTeamAddEntities(UUID squidUUID, UUID guardianUUID) throws ReflectiveOperationException {
            Object packet;
            String id = Laser.TEAM + TEAM_ID.getAndIncrement();
            if (XReflection.supports((int)17)) {
                ArrayList<String> players = new ArrayList<String>(2);
                players.add(squidUUID.toString());
                players.add(guardianUUID.toString());
                Constructor<?> ctor = packetTeam.getDeclaredConstructor(String.class, Integer.TYPE, Optional.class, Collection.class);
                ctor.setAccessible(true);
                packet = ctor.newInstance(id, 3, Optional.empty(), players);
            } else {
                packet = packetTeam.newInstance();
                NMSReflection.setField(packet, "a", id);
                NMSReflection.setField(packet, "f", Laser.COLLISION_RULE);
                NMSReflection.setField(packet, "i", 3);
                Collection players = (Collection)NMSReflection.getField(packetTeam, "h", packet);
                players.add(squidUUID.toString());
                players.add(guardianUUID.toString());
            }
            return packet;
        }

        public static Object teleport(NMSEntityInfo entityInfo, Location location) throws ReflectiveOperationException {
            Object packet;
            if (XReflection.supports((int)21)) {
                try {
                    NMSReflection.setLocation(entityInfo.entity, location);
                    packet = XReflection.of(packetTeleport).method().returns(packetTeleport).parameters(new ClassHandle[]{XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").named(new String[]{"Entity"})}).map(MinecraftMapping.MOJANG, "of").map(MinecraftMapping.OBFUSCATED, "a").reflect().invoke(entityInfo.entity);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return null;
                }
            } else if (XReflection.supports((int)17)) {
                try {
                    NMSReflection.setLocation(entityInfo.entity, location);
                    packet = packetTeleport.getConstructor((Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").named(new String[]{"Entity"}).unreflect()).newInstance(entityInfo.entity);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    return null;
                }
            } else {
                packet = packetTeleport.newInstance();
                NMSReflection.setField(packet, "a", entityInfo.id);
                NMSReflection.setField(packet, "b", location.getX());
                NMSReflection.setField(packet, "c", location.getY());
                NMSReflection.setField(packet, "d", location.getZ());
                NMSReflection.setField(packet, "e", (byte)(location.getYaw() * 256.0f / 360.0f));
                NMSReflection.setField(packet, "f", (byte)(location.getPitch() * 256.0f / 360.0f));
                NMSReflection.setField(packet, "g", true);
            }
            return packet;
        }

        private static Object createPacketMetadata(int entityId, Object watcher) throws ReflectiveOperationException {
            if (XReflection.supports((int)19)) {
                return packetMetadata.getConstructor(Integer.TYPE, List.class).newInstance(entityId, watcherPack.invoke(watcher, new Object[0]));
            }
            return packetMetadata.getConstructor(Integer.TYPE, watcher.getClass(), Boolean.TYPE).newInstance(entityId, watcher, false);
        }

        private static Object createDataWatcher(Object entity2, List<WatcherPair> watcherData) throws ReflectiveOperationException {
            if (XReflection.supports((int)21)) {
                Objects.requireNonNull(entity2);
                try {
                    Object watcher = NMSExtras.getDataWatcher((Object)entity2);
                    for (WatcherPair watcherDatum : watcherData) {
                        NMSReflection.tryWatcherSet(watcher, watcherDatum.id, watcherDatum.value);
                    }
                    return watcher;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
            Object watcher = watcherConstructor.newInstance(entity2);
            for (WatcherPair watcherDatum : watcherData) {
                try {
                    NMSReflection.tryWatcherSet(watcher, watcherDatum.id, watcherDatum.value);
                }
                catch (NullPointerException ex) {
                    watcherRegister.invoke(watcher, watcherDatum.id, watcherDatum.value);
                    if (!XReflection.supports((int)14)) continue;
                    NMSReflection.setField(watcher, "registrationLocked", false);
                }
            }
            return watcher;
        }

        private static void tryWatcherSet(Object watcher, Object watcherObject, Object watcherData) throws ReflectiveOperationException {
            try {
                watcherSet.invoke(watcher, watcherObject, watcherData);
            }
            catch (InvocationTargetException ex) {
                try {
                    watcherRegister.invoke(watcher, watcherObject, watcherData);
                    if (XReflection.supports((int)15)) {
                        watcherDirty.invoke(watcher, watcherObject);
                    }
                }
                catch (Throwable ex2) {
                    RuntimeException re = new RuntimeException("Failed to set watcher for " + watcher);
                    re.addSuppressed(ex);
                    re.addSuppressed(ex2);
                    throw re;
                }
            }
        }

        private static Method getMethodIgnoreParams(Class<?> clazz, String name) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(name)) continue;
                return method;
            }
            return null;
        }

        private static Method getMethodStarting(Class<?> clazz, String name, MethodType type) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(name) || method.getReturnType() != type.returnType()) continue;
                if (type.parameterCount() != 0 && type.parameterCount() <= method.getParameterCount()) {
                    int i = 0;
                    Parameter[] params = method.getParameters();
                    for (Class<?> param : type.parameterArray()) {
                        if (params[i++].getType() == param) continue;
                        i = -1;
                        break;
                    }
                    if (i == -1) continue;
                }
                method.setAccessible(true);
                return method;
            }
            return null;
        }

        private static void setField(Object instance, String name, Object value) throws ReflectiveOperationException {
            Field field = instance.getClass().getDeclaredField(name);
            field.setAccessible(true);
            field.set(instance, value);
        }

        private static Object getField(Class<?> clazz, String name, Object instance) throws ReflectiveOperationException {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(instance);
        }

        private static Object getField(String name, Object instance) throws ReflectiveOperationException {
            return NMSReflection.getField(instance.getClass(), name, instance);
        }

        static {
            guardian = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity.monster").map(MinecraftMapping.MOJANG, "Guardian").map(MinecraftMapping.SPIGOT, "EntityGuardian").unreflect();
            squid = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity.animal").map(MinecraftMapping.MOJANG, "Squid").map(MinecraftMapping.SPIGOT, "EntitySquid").unreflect();
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Object nmsWorld = null;
            MethodHandle setLocation = null;
            MethodHandle packetSpawn = null;
            MethodHandle blockPositionCtor = null;
            Class craftWorld = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB).named(new String[]{"CraftWorld"}).unreflect();
            Class entity2 = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").named(new String[]{"Entity"}).unreflect();
            Class entityLiving = NMSExtras.EntityLiving;
            Class craftSquid = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.CB, "entity").named(new String[]{"CraftSquid"}).unreflect();
            Class SynchedEntityData = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").map(MinecraftMapping.MOJANG, "SynchedEntityData").map(MinecraftMapping.SPIGOT, "DataWatcher").unreflect();
            MinecraftClassHandle SynchedEntityData$Builder = (MinecraftClassHandle)XReflection.of((Class)SynchedEntityData).inner((DynamicClassHandle)XReflection.ofMinecraft().map(MinecraftMapping.MOJANG, "Builder").map(MinecraftMapping.SPIGOT, "a"));
            Class DataWatcherObject = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").map(MinecraftMapping.MOJANG, "EntityDataAccessor").map(MinecraftMapping.SPIGOT, "DataWatcherObject").unreflect();
            Class EntityType2 = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "world.entity").map(MinecraftMapping.MOJANG, "EntityType").map(MinecraftMapping.SPIGOT, "EntityTypes").unreflect();
            Class packetSpawnClass = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundAddEntityPacket").map(MinecraftMapping.SPIGOT, (String)XReflection.v((int)19, (Object)"PacketPlayOutSpawnEntity").orElse((Object)"PacketPlayOutSpawnEntityLiving")).unreflect();
            packetRemove = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundRemoveEntitiesPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutEntityDestroy").unreflect();
            packetTeleport = XReflection.supports((int)1, (int)20, (int)0) ? (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundEntityPositionSyncPacket").map(MinecraftMapping.SPIGOT, "ClientboundEntityPositionSyncPacket").map(MinecraftMapping.OBFUSCATED, "acq").unreflect() : (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundTeleportEntityPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutEntityTeleport").map(MinecraftMapping.OBFUSCATED, "afu").unreflect();
            packetTeam = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundSetPlayerTeamPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutScoreboardTeam").unreflect();
            packetMetadata = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.protocol.game").map(MinecraftMapping.MOJANG, "ClientboundSetEntityDataPacket").map(MinecraftMapping.SPIGOT, "PacketPlayOutEntityMetadata").unreflect();
            try {
                Object[] objectArray;
                StaticClassHandle Entity2 = XReflection.of((Class)entity2);
                StaticClassHandle Guardian = XReflection.of(guardian);
                StaticClassHandle EntityTypeX = XReflection.of((Class)EntityType2);
                String watcherInvis = null;
                String watcherSpikes = null;
                String watcherAttacker = null;
                FieldMemberHandle watcherInvisH = Entity2.field().getter().returns(DataWatcherObject).makeAccessible();
                FieldMemberHandle watcherSpikesH = Guardian.field().getter().returns(DataWatcherObject).makeAccessible();
                FieldMemberHandle watcherAttackerH = Guardian.field().getter().returns(DataWatcherObject).makeAccessible();
                FieldMemberHandle squadType = EntityTypeX.field().getter().returns((ClassHandle)EntityTypeX).makeAccessible();
                FieldMemberHandle guardianType = EntityTypeX.field().getter().returns((ClassHandle)EntityTypeX).makeAccessible();
                if (XReflection.MINOR_NUMBER < 13) {
                    watcherInvis = "Z";
                    watcherSpikes = "bA";
                    watcherAttacker = "bB";
                    SQUID_TYPE = 94;
                    GUARDIAN_TYPE = 68;
                } else if (XReflection.MINOR_NUMBER == 13) {
                    watcherInvis = "ac";
                    watcherSpikes = "bF";
                    watcherAttacker = "bG";
                    SQUID_TYPE = 70;
                    GUARDIAN_TYPE = 28;
                } else if (XReflection.MINOR_NUMBER == 14) {
                    watcherInvis = "W";
                    watcherSpikes = "b";
                    watcherAttacker = "bD";
                    SQUID_TYPE = 73;
                    GUARDIAN_TYPE = 30;
                } else if (XReflection.MINOR_NUMBER == 15) {
                    watcherInvis = "T";
                    watcherSpikes = "b";
                    watcherAttacker = "bA";
                    SQUID_TYPE = 74;
                    GUARDIAN_TYPE = 31;
                } else if (XReflection.MINOR_NUMBER == 16) {
                    watcherInvis = "S";
                    watcherSpikes = "b";
                    watcherAttacker = "d";
                    SQUID_TYPE = 74;
                    GUARDIAN_TYPE = 31;
                } else if (XReflection.MINOR_NUMBER == 17) {
                    watcherInvis = "Z";
                    watcherSpikes = "b";
                    watcherAttacker = "e";
                    SQUID_TYPE = squadType.named(new String[]{"aJ"});
                    GUARDIAN_TYPE = guardianType.named(new String[]{"K"});
                } else if (XReflection.MINOR_NUMBER == 18) {
                    watcherInvis = "Z";
                    watcherSpikes = "b";
                    watcherAttacker = "e";
                    SQUID_TYPE = squadType.named(new String[]{"aJ"});
                    GUARDIAN_TYPE = guardianType.named(new String[]{"K"});
                } else if (XReflection.MINOR_NUMBER == 19 || XReflection.MINOR_NUMBER == 20) {
                    watcherInvis = (String)XReflection.v((int)20, (int)2, (Object)"ao").orElse((Object)"an");
                    watcherSpikes = "b";
                    watcherAttacker = "e";
                    SQUID_TYPE = squadType.named(new String[]{"aT"});
                    GUARDIAN_TYPE = guardianType.named(new String[]{"V"});
                } else {
                    watcherInvisH.map(MinecraftMapping.MOJANG, "DATA_SHARED_FLAGS_ID").map(MinecraftMapping.OBFUSCATED, "am");
                    watcherSpikesH.map(MinecraftMapping.MOJANG, "DATA_ID_MOVING").map(MinecraftMapping.OBFUSCATED, "a");
                    watcherAttackerH.map(MinecraftMapping.MOJANG, "DATA_ID_ATTACK_TARGET").map(MinecraftMapping.OBFUSCATED, "d");
                    SQUID_TYPE = squadType.map(MinecraftMapping.MOJANG, "SQUID").map(MinecraftMapping.OBFUSCATED, "bq");
                    GUARDIAN_TYPE = guardianType.map(MinecraftMapping.MOJANG, "GUARDIAN").map(MinecraftMapping.OBFUSCATED, "ai");
                }
                if (SQUID_TYPE instanceof FieldMemberHandle) {
                    SQUID_TYPE = ((FieldMemberHandle)SQUID_TYPE).get(null);
                    GUARDIAN_TYPE = ((FieldMemberHandle)GUARDIAN_TYPE).get(null);
                }
                if (watcherInvis == null) {
                    WATCHER_INVISILIBITY = watcherInvisH.get(null);
                    WATCHER_SPIKES = watcherSpikesH.get(null);
                    WATCHER_ATTACK_ID = watcherAttackerH.get(null);
                } else {
                    WATCHER_INVISILIBITY = NMSReflection.getField(entity2, watcherInvis, null);
                    WATCHER_SPIKES = NMSReflection.getField(guardian, watcherSpikes, null);
                    WATCHER_ATTACK_ID = NMSReflection.getField(guardian, watcherAttacker, null);
                }
                nmsWorld = craftWorld.getDeclaredMethod("getHandle", new Class[0]).invoke(Bukkit.getWorlds().get(0), new Object[0]);
                Objects.requireNonNull(nmsWorld, () -> "Could not get NMS world for: " + Bukkit.getWorlds().get(0));
                if (XReflection.supports((int)21)) {
                    Class SyncedDataHolder = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "network.syncher").named(new String[]{"SyncedDataHolder"}).unreflect();
                    Class WatcherItem = (Class)((MinecraftClassHandle)XReflection.of((Class)SynchedEntityData).inner((DynamicClassHandle)XReflection.ofMinecraft().map(MinecraftMapping.MOJANG, "DataItem").map(MinecraftMapping.SPIGOT, "Item"))).unreflect();
                    Entity$defineSynchedData = XReflection.of((Class)entity2).method().returns(Void.TYPE).parameters(new ClassHandle[]{SynchedEntityData$Builder}).map(MinecraftMapping.MOJANG, "defineSynchedData").map(MinecraftMapping.SPIGOT, "a").makeAccessible().reflect();
                    SynchedEntityData$Builder_Ctor = SynchedEntityData$Builder.constructor().parameters(new Class[]{SyncedDataHolder}).reflect();
                    SynchedEntityData$Builder_build = SynchedEntityData$Builder.method().returns(SynchedEntityData).map(MinecraftMapping.MOJANG, "build").map(MinecraftMapping.MOJANG, "a").reflect();
                    SynchedEntityData$Builder_define = SynchedEntityData$Builder.method().returns((ClassHandle)SynchedEntityData$Builder).parameters(new Class[]{DataWatcherObject, Object.class}).map(MinecraftMapping.MOJANG, "define").map(MinecraftMapping.MOJANG, "a").reflect();
                    WatcherItemEmptyArray = Array.newInstance(WatcherItem, 0);
                    watcherConstructor = SynchedEntityData.getDeclaredConstructor(SyncedDataHolder, WatcherItemEmptyArray.getClass());
                    watcherConstructor.setAccessible(true);
                } else {
                    watcherConstructor = SynchedEntityData.getDeclaredConstructor(entity2);
                }
                watcherSet = XReflection.of((Class)SynchedEntityData).method().returns(Void.TYPE).parameters(new Class[]{DataWatcherObject, Object.class}).map(MinecraftMapping.MOJANG, "set").map(MinecraftMapping.SPIGOT, (String)XReflection.v((int)18, (Object)"b").orElse((Object)"set")).reflectJvm();
                if (!XReflection.supports((int)21)) {
                    watcherRegister = XReflection.of((Class)SynchedEntityData).method().returns(Void.TYPE).parameters(new Class[]{DataWatcherObject, Object.class}).map(MinecraftMapping.SPIGOT, (String)XReflection.v((int)18, (Object)"a").orElse((Object)"register")).reflectJvm();
                }
                if (XReflection.supports((int)15)) {
                    watcherDirty = NMSReflection.getMethodIgnoreParams(SynchedEntityData, "markDirty");
                }
                if (XReflection.supports((int)19)) {
                    watcherPack = SynchedEntityData.getDeclaredMethod("b", new Class[0]);
                }
                Class blockPos = (Class)XReflection.ofMinecraft().inPackage(MinecraftPackage.NMS, "core").map(MinecraftMapping.MOJANG, "BlockPos").map(MinecraftMapping.SPIGOT, "BlockPosition").unreflect();
                blockPositionCtor = lookup.findConstructor(blockPos, (MethodType)XReflection.v((int)19, (Object)MethodType.methodType(Void.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE)).orElse((Object)MethodType.methodType(Void.TYPE, Double.TYPE, Double.TYPE, Double.TYPE)));
                packetSpawn = lookup.findConstructor(packetSpawnClass, (MethodType)XReflection.v((int)21, (Object)MethodType.methodType(Void.TYPE, entity2, Integer.TYPE, blockPos)).v(19, (Object)MethodType.methodType(Void.TYPE, entity2)).v(17, (Object)MethodType.methodType(Void.TYPE, entityLiving)).orElse((Object)MethodType.methodType(Void.TYPE)));
                if (XReflection.supports((int)17)) {
                    setLocation = XReflection.of((Class)entity2).method().map(MinecraftMapping.MOJANG, "moveTo").map(MinecraftMapping.SPIGOT, (String)XReflection.v((int)18, (Object)"a").orElse((Object)"setLocation")).returns(Void.TYPE).parameters(new Class[]{Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE}).reflect();
                }
                if (XReflection.supports((int)14)) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = XReflection.supports((int)17) ? SQUID_TYPE : EntityType2.getDeclaredField("SQUID").get(null);
                    objectArray = objectArray2;
                    objectArray2[1] = nmsWorld;
                } else {
                    Object[] objectArray3 = new Object[1];
                    objectArray = objectArray3;
                    objectArray3[0] = nmsWorld;
                }
                Object[] entityConstructorParams = objectArray;
                fakeSquidEntity = squid.getDeclaredConstructors()[0].newInstance(entityConstructorParams);
                fakeSquidWatcher = NMSReflection.createDataWatcher(fakeSquidEntity, Collections.singletonList(new WatcherPair(WATCHER_INVISILIBITY, (byte)32)));
            }
            catch (ReflectiveOperationException e) {
                e.printStackTrace();
            }
            BlockPositionCtor = blockPositionCtor;
            NMS_WORLD = nmsWorld;
            SET_LOCATION = setLocation;
            PACKET_SPAWN = packetSpawn;
        }

        private static final class WatcherPair {
            public final Object id;
            public final Object value;

            private WatcherPair(Object id, Object value) {
                this.id = Objects.requireNonNull(id);
                this.value = Objects.requireNonNull(value);
            }
        }
    }
}

