/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.kingdoms.config.accessor.ConfigAccessor;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.NoWhenBranchMatchedException;
import org.kingdoms.libs.kotlin.collections.CollectionsKt;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.libs.xseries.XItemStack;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.nbt.NBTTagId;
import org.kingdoms.nbt.tag.NBTTag;
import org.kingdoms.nbt.tag.NBTTagByte;
import org.kingdoms.nbt.tag.NBTTagByteArray;
import org.kingdoms.nbt.tag.NBTTagCompound;
import org.kingdoms.nbt.tag.NBTTagDouble;
import org.kingdoms.nbt.tag.NBTTagEnd;
import org.kingdoms.nbt.tag.NBTTagFloat;
import org.kingdoms.nbt.tag.NBTTagInt;
import org.kingdoms.nbt.tag.NBTTagIntArray;
import org.kingdoms.nbt.tag.NBTTagList;
import org.kingdoms.nbt.tag.NBTTagLong;
import org.kingdoms.nbt.tag.NBTTagLongArray;
import org.kingdoms.nbt.tag.NBTTagShort;
import org.kingdoms.nbt.tag.NBTTagString;
import org.kingdoms.platform.bukkit.item.ItemNBT;
import org.kingdoms.utils.ItemUtil;
import org.kingdoms.utils.config.ConfigSection;
import org.kingdoms.utils.config.NodeInterpreter;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0013J\u0018\u0010\u0014\u001a\u00020\u00002\u0010\u0010\n\u001a\f\u0012\b\u0012\u00060\fj\u0002`\r0\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u0007J\u0014\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\b\u0012\u00060\fj\u0002`\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/kingdoms/utils/KingdomsItemDeserializer;", "", "<init>", "()V", "context", "Lorg/kingdoms/locale/placeholders/context/MessagePlaceholderProvider;", "item", "Lorg/bukkit/inventory/ItemStack;", "section", "Lorg/kingdoms/utils/config/ConfigSection;", "restart", "Ljava/util/function/Consumer;", "Ljava/lang/Exception;", "Lorg/kingdoms/libs/kotlin/Exception;", "translate", "", "withContext", "withItem", "withSection", "Lorg/kingdoms/config/accessor/ConfigAccessor;", "withRestart", "deserialize", "deserializeNBT", "Lorg/kingdoms/nbt/tag/NBTTag;", "core"})
@SourceDebugExtension(value={"SMAP\nKingdomsItemDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KingdomsItemDeserializer.kt\norg/kingdoms/utils/KingdomsItemDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,115:1\n1#2:116\n1557#3:117\n1628#3,3:118\n1557#3:121\n1628#3,3:122\n*S KotlinDebug\n*F\n+ 1 KingdomsItemDeserializer.kt\norg/kingdoms/utils/KingdomsItemDeserializer\n*L\n89#1:117\n89#1:118,3\n92#1:121\n92#1:122,3\n*E\n"})
public final class KingdomsItemDeserializer {
    @NotNull
    private MessagePlaceholderProvider context;
    @Nullable
    private ItemStack item;
    @Nullable
    private ConfigSection section;
    @Nullable
    private Consumer<Exception> restart;
    private boolean translate;

    public KingdomsItemDeserializer() {
        MessagePlaceholderProvider messagePlaceholderProvider = MessagePlaceholderProvider.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)messagePlaceholderProvider, (String)"DEFAULT");
        this.context = messagePlaceholderProvider;
        this.translate = true;
    }

    @NotNull
    public final KingdomsItemDeserializer withContext(@NotNull MessagePlaceholderProvider context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        return this;
    }

    @NotNull
    public final KingdomsItemDeserializer withItem(@NotNull ItemStack item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.item = item;
        return this;
    }

    @NotNull
    public final KingdomsItemDeserializer withSection(@NotNull ConfigSection section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        this.section = section;
        return this;
    }

    @NotNull
    public final KingdomsItemDeserializer withSection(@NotNull ConfigAccessor section) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        this.section = section.getSection();
        return this;
    }

    @NotNull
    public final KingdomsItemDeserializer withRestart(@NotNull Consumer<Exception> restart) {
        Intrinsics.checkNotNullParameter(restart, (String)"restart");
        this.restart = restart;
        return this;
    }

    @NotNull
    public final KingdomsItemDeserializer translate(boolean translate) {
        this.translate = translate;
        return this;
    }

    @NotNull
    public final ItemStack deserialize() {
        ConfigSection configSection = this.section;
        if (configSection == null) {
            boolean $i$a$-requireNotNull-KingdomsItemDeserializer$deserialize$section$232 = false;
            String $i$a$-requireNotNull-KingdomsItemDeserializer$deserialize$section$232 = "Section is null";
            throw new IllegalArgumentException($i$a$-requireNotNull-KingdomsItemDeserializer$deserialize$section$232.toString());
        }
        ConfigSection section = configSection;
        if (this.item == null) {
            this.item = XItemStack.deserialize((ConfigurationSection)section.toBukkitConfigurationSection(), Function.identity(), this.restart);
        } else {
            ItemStack itemStack = this.item;
            Intrinsics.checkNotNull((Object)itemStack);
            this.item = XItemStack.edit((ItemStack)itemStack, (ConfigurationSection)section.toBukkitConfigurationSection(), Function.identity(), this.restart);
        }
        ItemStack itemStack = this.item;
        Intrinsics.checkNotNull((Object)itemStack);
        ItemStack item = itemStack;
        if (this.translate && item.hasItemMeta()) {
            ItemMeta meta = item.getItemMeta();
            ItemUtil.translate(meta, this.context);
            item.setItemMeta(meta);
        }
        String[] stringArray = new String[]{"nbt"};
        ConfigSection configSection2 = section.getSection(stringArray);
        if (configSection2 == null) {
            return item;
        }
        ConfigSection nbt = configSection2;
        NBTTagCompound root = ItemNBT.getTag(item);
        Map<String, ConfigSection> map = nbt.getSections();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getSections(...)");
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            ConfigSection value = (ConfigSection)entry.getValue();
            Intrinsics.checkNotNull((Object)value);
            root.set(key, this.deserializeNBT(value));
        }
        ItemStack itemStack2 = ItemNBT.setTag(item, root);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"setTag(...)");
        return itemStack2;
    }

    /*
     * WARNING - void declaration
     */
    private final NBTTag<?> deserializeNBT(ConfigSection section) {
        NBTTag nBTTag;
        String string = section.getString("type");
        Intrinsics.checkNotNull((Object)string);
        switch (WhenMappings.$EnumSwitchMapping$0[NBTTagId.valueOf(string).ordinal()]) {
            case 1: {
                String string2 = section.getString("value");
                Intrinsics.checkNotNull((Object)string2);
                NBTTagString nBTTagString = NBTTagString.of(string2);
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagString, (String)"of(...)");
                nBTTag = nBTTagString;
                break;
            }
            case 2: {
                String[] stringArray = new String[]{"value"};
                NBTTagByte nBTTagByte = NBTTagByte.of((byte)section.getInt(stringArray));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagByte, (String)"of(...)");
                nBTTag = nBTTagByte;
                break;
            }
            case 3: {
                String[] stringArray = new String[]{"value"};
                NBTTagShort nBTTagShort = NBTTagShort.of((short)section.getInt(stringArray));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagShort, (String)"of(...)");
                nBTTag = nBTTagShort;
                break;
            }
            case 4: {
                String[] stringArray = new String[]{"value"};
                NBTTagInt nBTTagInt = NBTTagInt.of(section.getInt(stringArray));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagInt, (String)"of(...)");
                nBTTag = nBTTagInt;
                break;
            }
            case 5: {
                String[] stringArray = new String[]{"value"};
                NBTTagFloat nBTTagFloat = NBTTagFloat.of(section.getFloat(stringArray));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagFloat, (String)"of(...)");
                nBTTag = nBTTagFloat;
                break;
            }
            case 6: {
                String[] stringArray = new String[]{"value"};
                NBTTagLong nBTTagLong = NBTTagLong.of(section.getLong(stringArray));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagLong, (String)"of(...)");
                nBTTag = nBTTagLong;
                break;
            }
            case 7: {
                String[] stringArray = new String[]{"value"};
                NBTTagDouble nBTTagDouble = NBTTagDouble.of(section.getDouble(stringArray));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagDouble, (String)"of(...)");
                nBTTag = nBTTagDouble;
                break;
            }
            case 8: {
                void $this$mapTo$iv$iv;
                String[] stringArray = new String[]{"value"};
                List<String> list = section.getStringList(stringArray);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStringList(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void x;
                    String string3 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)x);
                    collection.add(Long.parseLong((String)x));
                }
                long[] lArray = CollectionsKt.toLongArray((Collection)((List)destination$iv$iv));
                NBTTagLongArray nBTTagLongArray = NBTTagLongArray.of(Arrays.copyOf(lArray, lArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagLongArray, (String)"of(...)");
                nBTTag = nBTTagLongArray;
                break;
            }
            case 9: {
                String[] $i$f$map = new String[]{"value"};
                List<Integer> list = section.getIntegerList($i$f$map);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getIntegerList(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map2 = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Integer x = (Integer)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((byte)x.intValue());
                }
                byte[] byArray = CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
                NBTTagByteArray nBTTagByteArray = NBTTagByteArray.of(Arrays.copyOf(byArray, byArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagByteArray, (String)"of(...)");
                nBTTag = nBTTagByteArray;
                break;
            }
            case 10: {
                String[] stringArray = new String[]{"value"};
                List<Integer> list = section.getIntegerList(stringArray);
                Intrinsics.checkNotNullExpressionValue(list, (String)"getIntegerList(...)");
                int[] nArray = CollectionsKt.toIntArray((Collection)list);
                NBTTagIntArray nBTTagIntArray = NBTTagIntArray.of(Arrays.copyOf(nArray, nArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagIntArray, (String)"of(...)");
                nBTTag = nBTTagIntArray;
                break;
            }
            case 11: {
                NBTTagEnd nBTTagEnd = NBTTagEnd.instance();
                Intrinsics.checkNotNullExpressionValue((Object)nBTTagEnd, (String)"instance(...)");
                nBTTag = nBTTagEnd;
                break;
            }
            case 12: {
                String[] stringArray = new String[]{"value"};
                ConfigSection entries = section.getSection(stringArray);
                Intrinsics.checkNotNull((Object)entries);
                nBTTag = this.deserializeNBT(entries);
                break;
            }
            case 13: {
                List<ConfigSection> list = section.get(NodeInterpreter.SECTION_LIST, "value");
                if (list == null) {
                    NBTTagList<?> nBTTagList = NBTTagList.unknownEmpty();
                    Intrinsics.checkNotNullExpressionValue(nBTTagList, (String)"unknownEmpty(...)");
                    return nBTTagList;
                }
                List<ConfigSection> entries = list;
                List list2 = new ArrayList();
                for (ConfigSection entry : entries) {
                    list2.add(this.deserializeNBT(entry));
                }
                NBTTagList<?> nBTTagList = NBTTagList.ofUnknown(list2);
                Intrinsics.checkNotNull(nBTTagList);
                nBTTag = nBTTagList;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return nBTTag;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NBTTagId.values().length];
            try {
                nArray[NBTTagId.STRING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.BYTE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.SHORT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.INT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.FLOAT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LONG.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.DOUBLE.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LONG_ARRAY.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.BYTE_ARRAY.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.INT_ARRAY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.END.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.COMPOUND.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NBTTagId.LIST.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

