/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.utils;

import java.util.Arrays;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.locale.KingdomsLang;
import org.kingdoms.locale.messenger.Messenger;
import org.kingdoms.utils.string.Strings;

public enum Compass {
    NORTH,
    NORTH_EAST,
    EAST,
    SOUTH_EAST,
    SOUTH,
    SOUTH_WEST,
    WEST,
    NORTH_WEST;

    private final KingdomsLang language = KingdomsLang.valueOf("CARDINAL_DIRECTIONS_" + this.name());
    private final BlockFace blockFace = BlockFace.valueOf((String)this.name());
    public static final Compass[] CARDINAL_DIRECTIONS;

    public static Optional<Compass> getCardinalDirection(KingdomPlayer kp, String direction) {
        return Arrays.stream(CARDINAL_DIRECTIONS).filter(x -> x.language.parse(kp.getOfflinePlayer(), new Object[0]).toLowerCase(kp.getLanguage().getLocale()).equals(direction)).findFirst();
    }

    public KingdomsLang getLanguage() {
        return this.language;
    }

    @Deprecated
    public static Compass getCardinalDirection(float degrees) {
        if ((degrees %= 360.0f) < 0.0f) {
            degrees += 360.0f;
        }
        if (0.0f <= degrees && degrees < 22.5f) {
            return SOUTH;
        }
        if (22.5f <= degrees && degrees < 67.5f) {
            return SOUTH_WEST;
        }
        if (67.5f <= degrees && degrees < 112.5f) {
            return WEST;
        }
        if (112.5f <= degrees && degrees < 157.5f) {
            return NORTH_WEST;
        }
        if (157.5f <= degrees && degrees < 202.5f) {
            return NORTH;
        }
        if (202.5f <= degrees && degrees < 247.5f) {
            return SOUTH_EAST;
        }
        if (247.5f <= degrees && degrees < 292.5f) {
            return EAST;
        }
        if (292.5f <= degrees && degrees < 337.5f) {
            return NORTH_EAST;
        }
        if (337.5f <= degrees && degrees < 360.0f) {
            return SOUTH;
        }
        throw new AssertionError((Object)("Unexpected degrees for cardinal direction: " + degrees));
    }

    public static Compass getCardinalDirection(Entity entity2) {
        return Compass.getCardinalDirection(entity2.getLocation());
    }

    public static Compass getCardinalDirection(Location location) {
        return Compass.getCardinalDirection(location.getYaw());
    }

    public static Messenger translateCardinalDirection(Player player) {
        return Compass.getCardinalDirection((Entity)player).language;
    }

    public BlockFace toBlockFace() {
        return this.blockFace;
    }

    public String toString() {
        return Strings.capitalize(this.name());
    }

    static {
        CARDINAL_DIRECTIONS = Compass.values();
    }
}

