/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services.placeholders;

import java.util.Objects;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.kingdoms.locale.compiler.builders.context.PlainMessageBuilderContextProvider;
import org.kingdoms.locale.compiler.pieces.MessagePiece;
import org.kingdoms.locale.compiler.placeholders.Placeholder;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParseException;
import org.kingdoms.locale.compiler.placeholders.PlaceholderParser;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.utils.debugging.DebugNS;
import org.kingdoms.utils.debugging.KingdomsDebug;

final class ServicePlaceholders {
    ServicePlaceholders() {
    }

    protected static String requestInternal(OfflinePlayer player, Player other, String parameter, boolean assumeKingdomsPlaceholder) {
        Placeholder ph;
        try {
            ph = PlaceholderParser.parse(parameter, assumeKingdomsPlaceholder);
        }
        catch (PlaceholderParseException ex) {
            return "Kingdoms{Placeholder error: " + ex.getMessage() + '}';
        }
        if (ph == null) {
            KLogger.debug((DebugNS)KingdomsDebug.UNKNOWN$PLACEHOLDER, () -> "Requested null placeholder: " + parameter);
            return "Kingdoms{Unknown placeholder " + parameter + '}';
        }
        MessagePlaceholderProvider settings = new MessagePlaceholderProvider().withContext(player).other(other);
        PlainMessageBuilderContextProvider plain = new PlainMessageBuilderContextProvider(settings);
        new MessagePiece.Variable(ph).build(plain);
        String translated = plain.merge();
        return Objects.toString(translated);
    }
}

