/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services.managers;

import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.kingdoms.config.KingdomsConfig;
import org.kingdoms.locale.messenger.StaticMessenger;
import org.kingdoms.locale.placeholders.context.MessagePlaceholderProvider;
import org.kingdoms.main.KLogger;
import org.kingdoms.services.ServiceAuth;
import org.kingdoms.services.ServiceDiscordSRV;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.managers.SoftService;
import org.kingdoms.services.pets.PetInfo;
import org.kingdoms.services.pets.ServicePet;
import org.kingdoms.services.vanish.ServiceCommons;
import org.kingdoms.utils.config.ConfigSection;

public final class ServiceHandler {
    private static final List<BiConsumer<Player, String>> GLOBAL_MESSAGE_HANDLERS = new ArrayList<BiConsumer<Player, String>>();
    private static ServiceCommons[] COMMON_SERVICES;

    public static boolean bankServiceAvailable() {
        return SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.ECO);
    }

    public static void announce(KingdomsConfig.Chat section, Supplier<MessagePlaceholderProvider> settings) {
        if (!SoftService.DISCORDSRV.isAvailable()) {
            return;
        }
        String chan = section.getManager().noDefault().withProperty("channel").getString();
        if (Strings.isNullOrEmpty((String)chan)) {
            return;
        }
        TextChannel channel = ServiceDiscordSRV.getChannelWithoutChecks(chan);
        if (channel == null) {
            KLogger.error("Cannot find discord channel '" + chan + '\'');
            return;
        }
        ConfigSection msgSection = section.getManager().noDefault().getSection().getSection();
        ServiceDiscordSRV.sendMessage(channel, msgSection, (MessagePlaceholderProvider)settings.get());
    }

    public static boolean bankServiceNotAvailable(CommandSender player) {
        if (ServiceHandler.bankServiceAvailable()) {
            return false;
        }
        new StaticMessenger("&4Bank services are currently unavailable.\nThis command can only be used with an economy plugin present.\nIf you're the server admin please visit the hover:{&e&nFAQ;Click to open;@https://github.com/CryptoMorin/KingdomsX/wiki/FAQ#bank-services-are-currently-unavailable}&4 on how to setup an economy plugin\n or go to hover:{&e&nconfig.yml.yml;How to disable a command?;@https://github.com/CryptoMorin/KingdomsX/wiki/FAQ#how-to-disable-a-command}&4 config to disable the command.").sendError(player, new MessagePlaceholderProvider().usePrefix());
        return true;
    }

    public static PetInfo getPetInfo(Entity entity2) {
        return Stream.of(SoftService.MC_PETS, SoftService.MY_PET, SoftService.COMBAT_PETS, SoftService.SIMPLE_PETS).filter(SoftService::isAvailable).map(x -> ((ServicePet)x.getService()).getPetInfo(entity2)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static void addGlobalMessageHandler(BiConsumer<Player, String> handler) {
        GLOBAL_MESSAGE_HANDLERS.add(handler);
    }

    private static ServiceCommons[] getCommonServices() {
        if (COMMON_SERVICES == null) {
            COMMON_SERVICES = (ServiceCommons[])Stream.of(SoftService.ESSENTIALS, SoftService.CMI).filter(SoftService::isAvailable).map(x -> (ServiceCommons)x.getService()).toArray(ServiceCommons[]::new);
        }
        return COMMON_SERVICES;
    }

    public static boolean isVanished(Player player) {
        for (MetadataValue meta : player.getMetadata("vanished")) {
            if (!meta.asBoolean()) continue;
            return true;
        }
        for (ServiceCommons service : ServiceHandler.getCommonServices()) {
            if (!service.isVanished(player)) continue;
            return true;
        }
        return false;
    }

    public static boolean isNPC(Entity entity2) {
        return entity2.hasMetadata("NPC");
    }

    public static boolean isIgnoring(Player player, UUID ignoring) {
        for (ServiceCommons service : ServiceHandler.getCommonServices()) {
            if (!service.isIgnoring(player, ignoring)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInGodMode(Player player) {
        for (ServiceCommons service : ServiceHandler.getCommonServices()) {
            if (!service.isInGodMode(player)) continue;
            return true;
        }
        return false;
    }

    public static void sendGlobalMessage(Player player, String message) {
        for (BiConsumer<Player, String> handler : GLOBAL_MESSAGE_HANDLERS) {
            handler.accept(player, message);
        }
    }

    public static String getGroup(Player player) {
        return SoftService.VAULT.isAvailable() && ServiceVault.isAvailable(ServiceVault.Component.PERM) ? ServiceVault.getGroup(player) : null;
    }

    public static boolean isAuthenticated(Player player) {
        return !SoftService.AUTH_ME.isAvailable() || ((ServiceAuth)SoftService.AUTH_ME.getService()).isAuthenticated(player);
    }

    public static void logPrivateMessage(Player player, String str) {
        if (SoftService.DISCORDSRV.isAvailable()) {
            ServiceDiscordSRV.logPrivateMessages(player, str);
        }
    }
}

