/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services;

import org.bukkit.OfflinePlayer;
import org.kingdoms.constants.economy.Balance;
import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.services.ServiceVault;
import org.kingdoms.services.VaultEconomy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kingdoms/services/VaultBalance;", "Lorg/kingdoms/constants/economy/Balance;", "account", "Lorg/bukkit/OfflinePlayer;", "<init>", "(Lorg/bukkit/OfflinePlayer;)V", "get", "", "set", "value", "", "getEconomy", "Lorg/kingdoms/services/VaultEconomy;", "vault"})
public final class VaultBalance
implements Balance {
    @NotNull
    private final OfflinePlayer account;

    public VaultBalance(@NotNull OfflinePlayer account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.account = account;
    }

    @Override
    public double get() {
        return ServiceVault.getMoney(this.account);
    }

    @Override
    public double set(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        double bal = this.get();
        double dbVal = value.doubleValue();
        if (bal > dbVal) {
            ServiceVault.withdraw(this.account, bal - dbVal);
        } else if (bal < dbVal) {
            ServiceVault.deposit(this.account, dbVal - bal);
        }
        return dbVal;
    }

    @Override
    @NotNull
    public VaultEconomy getEconomy() {
        return VaultEconomy.INSTANCE;
    }
}

