/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services;

import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.kingdoms.services.Service;
import org.kingdoms.services.VaultBalance;

public final class ServiceVault
implements Service {
    private static Economy getEconomy() {
        RegisteredServiceProvider service = Bukkit.getServicesManager().getRegistration(Economy.class);
        return service == null ? null : (Economy)service.getProvider();
    }

    private static Permission getPermission() {
        RegisteredServiceProvider service = Bukkit.getServicesManager().getRegistration(Permission.class);
        return service == null ? null : (Permission)service.getProvider();
    }

    private static Chat getChat() {
        RegisteredServiceProvider service = Bukkit.getServicesManager().getRegistration(Chat.class);
        return service == null ? null : (Chat)service.getProvider();
    }

    public static boolean isAvailable(Component component) {
        switch (component.ordinal()) {
            case 0: {
                return ServiceVault.getEconomy() != null;
            }
            case 1: {
                return ServiceVault.getChat() != null;
            }
            case 2: {
                return ServiceVault.getPermission() != null;
            }
        }
        throw new AssertionError((Object)("Unknown Vault component: " + (Object)((Object)component)));
    }

    public static double getMoney(OfflinePlayer player) {
        return ServiceVault.getEconomy() == null ? 0.0 : ServiceVault.getEconomy().getBalance(player);
    }

    public static void deposit(OfflinePlayer player, double amount) {
        ServiceVault.getEconomy().depositPlayer(player, amount);
    }

    public static boolean hasMoney(OfflinePlayer player, double amount) {
        return ServiceVault.getEconomy() != null && ServiceVault.getEconomy().has(player, amount);
    }

    public static void addPermission(OfflinePlayer player, String permission) {
        ServiceVault.getPermission().playerAddTransient(player, permission);
    }

    public static void removePermission(OfflinePlayer player, String permission) {
        ServiceVault.getPermission().playerRemoveTransient(player, permission);
    }

    public static String getDisplayName(Player player) {
        Chat chat = ServiceVault.getChat();
        if (chat == null) {
            return player.getDisplayName();
        }
        String prefix = chat.getPlayerPrefix(player);
        String suffix = chat.getPlayerSuffix(player);
        return prefix + player.getName() + suffix;
    }

    public static void withdraw(OfflinePlayer player, double amount) {
        ServiceVault.getEconomy().withdrawPlayer(player, amount);
    }

    public static VaultBalance getBalance(OfflinePlayer player) {
        return new VaultBalance(player);
    }

    public static String getGroup(Player player) {
        if (ServiceVault.getPermission() == null) {
            return "default";
        }
        return ServiceVault.getPermission().hasGroupSupport() ? ServiceVault.getPermission().getPrimaryGroup(player) : "default";
    }

    public static enum Component {
        ECO,
        CHAT,
        PERM;

    }
}

