/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.services;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.Interaction;
import io.github.thebusybiscuit.slimefun4.libraries.dough.protection.ProtectionModule;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.plugin.Plugin;
import org.kingdoms.constants.group.Kingdom;
import org.kingdoms.constants.group.model.relationships.StandardRelationAttribute;
import org.kingdoms.constants.land.Land;
import org.kingdoms.constants.land.location.SimpleChunkLocation;
import org.kingdoms.constants.land.location.SimpleLocation;
import org.kingdoms.constants.player.KingdomPlayer;
import org.kingdoms.main.KLogger;
import org.kingdoms.main.Kingdoms;
import org.kingdoms.managers.Masswar;
import org.kingdoms.managers.land.BuildingProcessor;
import org.kingdoms.managers.pvp.PvPManager;
import org.kingdoms.services.Service;

public final class ServiceSlimefun
implements ProtectionModule,
Service {
    @Override
    public void enable() {
        Bukkit.getScheduler().runTaskLater((Plugin)Kingdoms.get(), () -> {
            try {
                Slimefun.getProtectionManager().registerModule(Bukkit.getPluginManager(), Kingdoms.get().getName(), kingdomsPlugin -> new ServiceSlimefun());
                KLogger.info("Successfully injected Slimefun protection module.");
            }
            catch (Throwable throwable) {
                KLogger.error("An error occurred while injecting protection module into Slimefun:");
                throwable.printStackTrace();
            }
        }, 100L);
    }

    public void load() {
        KLogger.info("Initializing Slimefun support...");
    }

    public Plugin getPlugin() {
        return Kingdoms.get();
    }

    public boolean hasPermission(OfflinePlayer player, Location location, Interaction interaction) {
        KingdomPlayer kp = KingdomPlayer.getKingdomPlayer(player);
        if (kp.isAdmin()) {
            return true;
        }
        Kingdom playerKingdom = kp.getKingdom();
        SimpleLocation simpleLocation = SimpleLocation.of(location);
        SimpleChunkLocation landLocation = simpleLocation.toSimpleChunkLocation();
        Land land = landLocation.getLand();
        boolean isClaimed = land != null && land.isClaimed();
        Kingdom landKingdom = isClaimed ? land.getKingdom() : null;
        switch (interaction) {
            case ATTACK_ENTITY: 
            case ATTACK_PLAYER: {
                switch (PvPManager.getPvpType()) {
                    case MASSWAR: {
                        return Masswar.getInstance().isRunning();
                    }
                    case CLAIMED: {
                        return isClaimed;
                    }
                    case UNCLAIMED: {
                        return !isClaimed;
                    }
                }
                return true;
            }
            case BREAK_BLOCK: 
            case PLACE_BLOCK: {
                return new BuildingProcessor(kp, simpleLocation, interaction == Interaction.PLACE_BLOCK).processAll().process().isSuccessful();
            }
            case INTERACT_BLOCK: 
            case INTERACT_ENTITY: {
                return StandardRelationAttribute.INTERACT.hasAttribute(playerKingdom, landKingdom);
            }
        }
        return true;
    }
}

