/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.location;

import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmField;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.BlockPoint3D;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Location;
import org.kingdoms.server.location.LocationUtils;
import org.kingdoms.server.location.Point3D;
import org.kingdoms.server.location.World;
import org.kingdoms.utils.internal.string.CommaDataSplitStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0001J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0003J\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u001bJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010!\u001a\u00020\u0000J\u0006\u0010\"\u001a\u00020\u0000J\u000e\u0010#\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0000J\b\u0010$\u001a\u00020%H\u0016J\u0013\u0010&\u001a\u00020'2\b\u0010\u000f\u001a\u0004\u0018\u00010(H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006,"}, d2={"Lorg/kingdoms/server/location/Vector3;", "Lorg/kingdoms/server/location/Point3D;", "x", "", "y", "z", "<init>", "(DDD)V", "getX", "()D", "getY", "getZ", "toBlockVector", "Lorg/kingdoms/server/location/BlockVector3;", "add", "other", "Lorg/kingdoms/server/location/BlockPoint3D;", "inWorld", "Lorg/kingdoms/server/location/Location;", "world", "Lorg/kingdoms/server/location/World;", "lengthSq", "getMinimum", "v2", "length", "normalize", "withX", "", "withY", "withZ", "divide", "by", "getMaximum", "floor", "ceil", "dot", "hashCode", "", "equals", "", "", "toString", "", "Companion", "shared"})
public final class Vector3
implements Point3D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double z;
    @JvmField
    @NotNull
    public static final Vector3 ZERO = Companion.of(0, 0, 0);

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @NotNull
    public final BlockVector3 toBlockVector() {
        return BlockVector3.Companion.of(LocationUtils.INSTANCE.toBlock(this.getX()), LocationUtils.INSTANCE.toBlock(this.getY()), LocationUtils.INSTANCE.toBlock(this.getZ()));
    }

    @NotNull
    public final Vector3 add(double x, double y, double z) {
        return Companion.of(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    @NotNull
    public final Vector3 add(@NotNull BlockPoint3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final Vector3 add(@NotNull Point3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final Location inWorld(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        return Location.Companion.of(world, this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
    }

    public final double lengthSq() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        return x * x + y * y + z * z;
    }

    @NotNull
    public final Vector3 getMinimum(@NotNull Vector3 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return Companion.of(Math.min(this.getX(), v2.getX()), Math.min(this.getY(), v2.getY()), Math.min(this.getZ(), v2.getZ()));
    }

    public final double length() {
        return Math.sqrt(this.lengthSq());
    }

    @NotNull
    public final Vector3 normalize() {
        double len = this.length();
        return Companion.of(this.getX() / len, this.getY() / len, this.getZ() / len);
    }

    @NotNull
    public final Vector3 withX(@NotNull Number x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return Companion.of(x, this.getY(), this.getZ());
    }

    @NotNull
    public final Vector3 withY(@NotNull Number y) {
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        return Companion.of(this.getX(), y, this.getZ());
    }

    @NotNull
    public final Vector3 withZ(@NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return Companion.of(this.getX(), this.getY(), z);
    }

    @NotNull
    public final Vector3 divide(@NotNull Number by) {
        Intrinsics.checkNotNullParameter((Object)by, (String)"by");
        double by2 = by.doubleValue();
        return Companion.of(this.getX() / by2, this.getY() / by2, this.getZ() / by2);
    }

    @NotNull
    public final Vector3 getMaximum(@NotNull Vector3 v2) {
        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
        return Companion.of(Math.max(this.getX(), v2.getX()), Math.max(this.getY(), v2.getY()), Math.max(this.getZ(), v2.getZ()));
    }

    @NotNull
    public final Vector3 floor() {
        return Companion.of(Math.floor(this.getX()), Math.floor(this.getY()), Math.floor(this.getZ()));
    }

    @NotNull
    public final Vector3 ceil() {
        return Companion.of(Math.ceil(this.getX()), Math.ceil(this.getY()), Math.ceil(this.getZ()));
    }

    public final double dot(@NotNull Vector3 other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getX() * other.getX() + this.getY() * other.getY() + this.getZ() * other.getZ();
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Vector3)) {
            return false;
        }
        return this.getX() == ((Vector3)other).getX() && this.getY() == ((Vector3)other).getY() && this.getZ() == ((Vector3)other).getZ();
    }

    @NotNull
    public String toString() {
        return "Vector3(" + this.getX() + ", " + this.getY() + ", " + this.getZ() + ')';
    }

    @JvmStatic
    @NotNull
    public static final Vector3 of(@NotNull BlockPoint3D other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final Vector3 of(@NotNull Point3D other) {
        return Companion.of(other);
    }

    @JvmStatic
    @NotNull
    public static final Vector3 of(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        return Companion.of(x, y, z);
    }

    @JvmStatic
    @NotNull
    public static final Vector3 fromString(@NotNull String str) {
        return Companion.fromString(str);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\tH\u0007J \u0010\u0006\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000bH\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/server/location/Vector3$Companion;", "", "<init>", "()V", "ZERO", "Lorg/kingdoms/server/location/Vector3;", "of", "other", "Lorg/kingdoms/server/location/BlockPoint3D;", "Lorg/kingdoms/server/location/Point3D;", "x", "", "y", "z", "fromString", "str", "", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Vector3 of(@NotNull BlockPoint3D other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new Vector3(other.getX(), other.getY(), other.getZ());
        }

        @JvmStatic
        @NotNull
        public final Vector3 of(@NotNull Point3D other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return new Vector3(other.getX(), other.getY(), other.getZ());
        }

        @JvmStatic
        @NotNull
        public final Vector3 of(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Intrinsics.checkNotNullParameter((Object)z, (String)"z");
            return new Vector3(x.doubleValue(), y.doubleValue(), z.doubleValue());
        }

        @JvmStatic
        @NotNull
        public final Vector3 fromString(@NotNull String str) {
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            CommaDataSplitStrategy $this$fromString_u24lambda_u240 = new CommaDataSplitStrategy(str, 3);
            boolean bl = false;
            return new Vector3($this$fromString_u24lambda_u240.nextDouble(), $this$fromString_u24lambda_u240.nextDouble(), $this$fromString_u24lambda_u240.nextDouble());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

