/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.location;

import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.libs.kotlin.jvm.internal.SourceDebugExtension;
import org.kingdoms.server.location.Directional;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.utils.internal.numbers.NumberExtensions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/kingdoms/server/location/LocationUtils;", "", "<init>", "()V", "PII", "", "toBlock", "", "num", "fromDirection", "Lorg/kingdoms/server/location/Directional;", "vector", "Lorg/kingdoms/server/location/Vector3;", "shared"})
@SourceDebugExtension(value={"SMAP\nLocationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocationUtils.kt\norg/kingdoms/server/location/LocationUtils\n+ 2 NumberExtensions.kt\norg/kingdoms/utils/internal/numbers/NumberExtensions\n*L\n1#1,47:1\n5#2:48\n5#2:49\n*S KotlinDebug\n*F\n+ 1 LocationUtils.kt\norg/kingdoms/server/location/LocationUtils\n*L\n39#1:48\n40#1:49\n*E\n"})
public final class LocationUtils {
    @NotNull
    public static final LocationUtils INSTANCE = new LocationUtils();
    public static final double PII = Math.PI * 2;

    private LocationUtils() {
    }

    public final int toBlock(double num) {
        int floor = (int)num;
        return (double)floor == num ? floor : floor - (int)(Double.doubleToRawLongBits(num) >>> 63);
    }

    @NotNull
    public final Directional fromDirection(@NotNull Vector3 vector) {
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        double x = vector.getX();
        double y = vector.getY();
        double z = vector.getZ();
        if (x == 0.0 && z == 0.0) {
            return Directional.Companion.of(Float.valueOf(0.0f), Float.valueOf(y > 0.0 ? -90.0f : 90.0f));
        }
        double theta = Math.atan2(-x, z);
        float yaw = (float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2));
        NumberExtensions numberExtensions = NumberExtensions.INSTANCE;
        double $this$squared$iv = x;
        boolean $i$f$squared = false;
        double x2 = $this$squared$iv * $this$squared$iv;
        NumberExtensions numberExtensions2 = NumberExtensions.INSTANCE;
        double $this$squared$iv2 = z;
        boolean $i$f$squared2 = false;
        double z2 = $this$squared$iv2 * $this$squared$iv2;
        double xz = Math.sqrt(x2 + z2);
        float pitch = (float)Math.toDegrees(Math.atan(-y / xz));
        return Directional.Companion.of(Float.valueOf(yaw), Float.valueOf(pitch));
    }
}

