/*
 * Decompiled with CFR 0.152.
 */
package org.kingdoms.server.location;

import org.kingdoms.libs.jetbrains.annotations.NotNull;
import org.kingdoms.libs.jetbrains.annotations.Nullable;
import org.kingdoms.libs.kotlin.Metadata;
import org.kingdoms.libs.kotlin.jvm.JvmStatic;
import org.kingdoms.libs.kotlin.jvm.internal.DefaultConstructorMarker;
import org.kingdoms.libs.kotlin.jvm.internal.Intrinsics;
import org.kingdoms.server.location.BlockPoint3D;
import org.kingdoms.server.location.BlockVector3;
import org.kingdoms.server.location.Directional;
import org.kingdoms.server.location.Point3D;
import org.kingdoms.server.location.Vector3;
import org.kingdoms.server.location.Vector3Location;
import org.kingdoms.server.location.World;
import org.kingdoms.server.location.WorldContainer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 +2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001+B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020!2\u0006\u0010\b\u001a\u00020!2\u0006\u0010\t\u001a\u00020!J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\"J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\"J\u001e\u0010#\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020!2\u0006\u0010\b\u001a\u00020!2\u0006\u0010\t\u001a\u00020!J\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020)J \u0010*\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020!2\u0006\u0010\b\u001a\u00020!2\u0006\u0010\t\u001a\u00020!H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\b\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\f\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016\u00a8\u0006,"}, d2={"Lorg/kingdoms/server/location/Location;", "Lorg/kingdoms/server/location/Directional;", "Lorg/kingdoms/server/location/WorldContainer;", "Lorg/kingdoms/server/location/Point3D;", "world", "Lorg/kingdoms/server/location/World;", "x", "", "y", "z", "yaw", "", "pitch", "<init>", "(Lorg/kingdoms/server/location/World;DDDFF)V", "getWorld", "()Lorg/kingdoms/server/location/World;", "getX", "()D", "getY", "getZ", "getYaw", "()F", "getPitch", "hashCode", "", "equals", "", "other", "", "toString", "", "add", "", "Lorg/kingdoms/server/location/BlockPoint3D;", "subtract", "toBlockVector", "Lorg/kingdoms/server/location/BlockVector3;", "toVectorLocation", "Lorg/kingdoms/server/location/Vector3Location;", "toVector", "Lorg/kingdoms/server/location/Vector3;", "simpleAdd", "Companion", "shared"})
public final class Location
implements Directional,
WorldContainer,
Point3D {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    public Location(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    @Override
    @NotNull
    public World getWorld() {
        return this.world;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    public int hashCode() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Location)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getWorld(), (Object)((Location)other).getWorld()) && this.getX() == ((Location)other).getX() && this.getY() == ((Location)other).getY() && this.getZ() == ((Location)other).getZ() && this.getYaw() == ((Location)other).getYaw() && this.getPitch() == ((Location)other).getPitch();
    }

    @NotNull
    public String toString() {
        return "Location(world=" + this.getWorld() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ')';
    }

    @NotNull
    public final Location add(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return this.simpleAdd(x, y, z);
    }

    @NotNull
    public final Location add(@NotNull BlockPoint3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final Location add(@NotNull Point3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final Location subtract(@NotNull BlockPoint3D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.subtract(other.getX(), other.getY(), other.getZ());
    }

    @NotNull
    public final Location subtract(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        Intrinsics.checkNotNullParameter((Object)z, (String)"z");
        return this.simpleAdd(-x.doubleValue(), -y.doubleValue(), -z.doubleValue());
    }

    @NotNull
    public final BlockVector3 toBlockVector() {
        return BlockVector3.Companion.of((int)this.getX(), (int)this.getY(), (int)this.getZ());
    }

    @NotNull
    public final Vector3Location toVectorLocation() {
        return Vector3Location.Companion.of(this.getWorld(), this.getX(), this.getY(), this.getZ());
    }

    @NotNull
    public final Vector3 toVector() {
        return Vector3.Companion.of(this.getX(), this.getY(), this.getZ());
    }

    private final Location simpleAdd(Number x, Number y, Number z) {
        return Companion.of(this.getWorld(), this.getX() + x.doubleValue(), this.getY() + y.doubleValue(), this.getZ() + z.doubleValue(), this.getYaw(), this.getPitch());
    }

    @JvmStatic
    @NotNull
    public static final Void modify() {
        return Companion.modify();
    }

    @JvmStatic
    @NotNull
    public static final Location of(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
        return Companion.of(world, x, y, z, yaw, pitch);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\t\u0010\u0004\u001a\u00020\u0005H\u0087\bJ8\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a8\u0006\u0011"}, d2={"Lorg/kingdoms/server/location/Location$Companion;", "", "<init>", "()V", "modify", "", "of", "Lorg/kingdoms/server/location/Location;", "world", "Lorg/kingdoms/server/location/World;", "x", "", "y", "z", "yaw", "", "pitch", "shared"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Void modify() {
            boolean $i$f$modify = false;
            throw new UnsupportedOperationException("Cannot modify immutable location");
        }

        @JvmStatic
        @NotNull
        public final Location of(@NotNull World world, double x, double y, double z, float yaw, float pitch) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return new Location(world, x, y, z, yaw, pitch);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

